/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie.filter;

import com.alibaba.fastjson.JSON;
import java.nio.CharBuffer;
import java.nio.charset.StandardCharsets;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.goalie.Context;
import org.aoju.bus.starter.goalie.GoalieConfiguration;
import org.aoju.bus.starter.goalie.GoalieProperties;
import org.reactivestreams.Publisher;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferUtils;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.http.server.reactive.ServerHttpResponseDecorator;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnBean(value={GoalieConfiguration.class})
@Order(value=0x7FFFFFFE)
public class EncryptFilter
implements WebFilter {
    @Autowired
    GoalieProperties.Server.Encrypt encrypt;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        if (this.encrypt.isEnabled()) {
            exchange = exchange.mutate().response((ServerHttpResponse)this.process(exchange)).build();
        }
        return chain.filter(exchange);
    }

    private void doEncrypt(Message message) {
        if (ObjectKit.isNotNull((Object)message.getData())) {
            message.setData((Object)Builder.encrypt((String)this.encrypt.getType(), (String)this.encrypt.getKey(), (String)JSON.toJSONString((Object)message.getData()), (java.nio.charset.Charset)Charset.UTF_8));
        }
    }

    private ServerHttpResponseDecorator process(final ServerWebExchange exchange) {
        return new ServerHttpResponseDecorator(exchange.getResponse()){

            public Mono<Void> writeWith(Publisher<? extends DataBuffer> body) {
                boolean isSign = Context.get((ServerWebExchange)exchange).getAssets().isSign();
                if (isSign) {
                    Flux flux = Flux.from(body);
                    return super.writeWith((Publisher)DataBufferUtils.join((Publisher)flux).map(dataBuffer -> {
                        CharBuffer charBuffer = StandardCharsets.UTF_8.decode(dataBuffer.asByteBuffer());
                        DataBufferUtils.release((DataBuffer)dataBuffer);
                        Message message = (Message)JSON.parseObject((String)charBuffer.toString(), Message.class);
                        EncryptFilter.this.doEncrypt(message);
                        return this.bufferFactory().wrap(JSON.toJSONString((Object)message).getBytes());
                    }));
                }
                return super.writeWith(body);
            }
        };
    }
}

