/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie.filter;

import java.util.Map;
import java.util.Objects;
import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.core.lang.exception.BusinessException;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.goalie.Context;
import org.aoju.bus.starter.goalie.GoalieConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnBean(value={GoalieConfiguration.class})
@Order(value=-2147483648)
public class PrimaryFilter
implements WebFilter {
    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        ServerHttpRequest request = exchange.getRequest();
        if (Objects.equals(request.getMethod(), HttpMethod.GET)) {
            MultiValueMap params2 = request.getQueryParams();
            Context.get((ServerWebExchange)exchange).setRequestMap(params2.toSingleValueMap());
            this.doParams(exchange);
            return chain.filter(exchange);
        }
        return exchange.getFormData().flatMap(params -> {
            Context.get((ServerWebExchange)exchange).setRequestMap(params.toSingleValueMap());
            this.doParams(exchange);
            return chain.filter(exchange);
        });
    }

    private void doParams(ServerWebExchange exchange) {
        Context context = Context.get((ServerWebExchange)exchange);
        Map params = context.getRequestMap();
        if (StringKit.isBlank((CharSequence)((CharSequence)params.get("method")))) {
            throw new BusinessException(ErrorCode.EM_100108);
        }
        if (StringKit.isBlank((CharSequence)((CharSequence)params.get("v")))) {
            throw new BusinessException(ErrorCode.EM_100107);
        }
        String format = (String)params.get("format");
        if (StringKit.isBlank((CharSequence)format)) {
            throw new BusinessException(ErrorCode.EM_100111);
        }
        context.setFormat(Context.Format.valueOf((String)format));
    }
}

