/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.goalie.filter;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.aoju.bus.base.consts.ErrorCode;
import org.aoju.bus.base.entity.OAuth2;
import org.aoju.bus.core.lang.exception.BusinessException;
import org.aoju.bus.core.toolkit.BeanKit;
import org.aoju.bus.goalie.Assets;
import org.aoju.bus.goalie.Athlete;
import org.aoju.bus.goalie.Context;
import org.aoju.bus.goalie.metric.Authorize;
import org.aoju.bus.goalie.metric.Delegate;
import org.aoju.bus.starter.goalie.GoalieConfiguration;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpMethod;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import org.springframework.web.server.WebFilter;
import org.springframework.web.server.WebFilterChain;
import reactor.core.publisher.Mono;

@Component
@ConditionalOnBean(value={GoalieConfiguration.class})
@Order(value=-2147483646)
public class AuthorizeFilter
implements WebFilter {
    @Autowired
    Athlete athlete;
    @Autowired
    Authorize authorize;

    public Mono<Void> filter(ServerWebExchange exchange, WebFilterChain chain) {
        Context context = Context.get((ServerWebExchange)exchange);
        Map params = context.getRequestMap();
        context.setFormat(Context.Format.valueOf((String)((String)params.get("format"))));
        String method = (String)params.get("method");
        String version = (String)params.get("v");
        List assetsList = this.athlete.getAssets().parallelStream().filter(asset -> Objects.equals(method, asset.getMethod())).collect(Collectors.toList());
        if (assetsList.size() < 1) {
            return Mono.error((Throwable)new BusinessException(ErrorCode.EM_100103));
        }
        Assets assets = assetsList.parallelStream().filter(c -> Objects.equals(version, c.getVersion())).findFirst().orElseThrow(() -> new BusinessException(ErrorCode.EM_100102));
        this.checkMethod(exchange.getRequest(), assets);
        this.checkTokenIfNecessary(exchange.getRequest(), assets, params);
        this.fillXParam(exchange, params);
        this.cleanParam(params);
        context.setAssets(assets);
        return chain.filter(exchange);
    }

    private void checkMethod(ServerHttpRequest request, Assets assets) {
        if (!Objects.equals(request.getMethod(), assets.getHttpMethod())) {
            if (Objects.equals(assets.getHttpMethod(), HttpMethod.GET)) {
                throw new BusinessException(ErrorCode.EM_100200);
            }
            if (Objects.equals(assets.getHttpMethod(), HttpMethod.POST)) {
                throw new BusinessException(ErrorCode.EM_100201);
            }
            throw new BusinessException(ErrorCode.EM_100508);
        }
    }

    private void checkTokenIfNecessary(ServerHttpRequest request, Assets assets, Map<String, String> params) {
        if (assets.isToken()) {
            String token = request.getHeaders().getFirst("X-Access-Token");
            Delegate delegate = this.authorize.authorize(token);
            if (delegate.isOk()) {
                OAuth2 auth2 = delegate.getOAuth2();
                Map map = BeanKit.beanToMap((Object)auth2, (boolean)false, (boolean)true);
                map.forEach((k, v) -> params.put((String)k, v.toString()));
            } else {
                throw new BusinessException(delegate.getMessage().errcode, delegate.getMessage().errmsg);
            }
        }
    }

    private void cleanParam(Map<String, String> params) {
        params.remove("method");
        params.remove("format");
        params.remove("v");
    }

    private void fillXParam(ServerWebExchange exchange, Map<String, String> requestParam) {
        requestParam.put("x-remote-ip", exchange.getRequest().getHeaders().getFirst("x-real-ip"));
    }
}

