/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.banner;

import java.awt.Color;
import java.awt.Image;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import org.aoju.bus.logger.Logger;

public class ImageBanner {
    private static final double RED_WEIGHT = 0.2126;
    private static final double GREEN_WEIGHT = 0.7152;
    private static final double BLUE_WEIGHT = 0.0722;
    private File image;
    private Map<String, Color> colors = new HashMap<String, Color>();

    public ImageBanner(File image) {
        if (image == null || !image.exists()) {
            throw new RuntimeException("Image not found !");
        }
        this.image = image;
        this.colorsInit();
    }

    private static int getLuminance(Color color, boolean inverse) {
        double red = color.getRed();
        double green = color.getGreen();
        double blue = color.getBlue();
        double luminance = inverse ? 0.2126 * (255.0 - red) + 0.7152 * (255.0 - green) + 0.0722 * (255.0 - blue) : 0.2126 * red + 0.7152 * green + 0.0722 * blue;
        return (int)Math.ceil(luminance / 255.0 * 100.0);
    }

    private static char getAsciiCharacter(Color color, boolean dark) {
        double luminance = ImageBanner.getLuminance(color, dark);
        if (luminance >= 90.0) {
            return ' ';
        }
        if (luminance >= 80.0) {
            return '.';
        }
        if (luminance >= 70.0) {
            return '*';
        }
        if (luminance >= 60.0) {
            return ':';
        }
        if (luminance >= 50.0) {
            return 'o';
        }
        if (luminance >= 40.0) {
            return '&';
        }
        if (luminance >= 30.0) {
            return '8';
        }
        if (luminance >= 20.0) {
            return '#';
        }
        return '@';
    }

    private static double getColorDistance(Color color1, Color color2) {
        double redDelta = (double)(color1.getRed() - color2.getRed()) * 0.2126;
        double greenDelta = (double)(color1.getGreen() - color2.getGreen()) * 0.7152;
        double blueDelta = (double)(color1.getBlue() - color2.getBlue()) * 0.0722;
        return Math.pow(redDelta, 2.0) + Math.pow(greenDelta, 2.0) + Math.pow(blueDelta, 2.0);
    }

    private static BufferedImage resizeImage(BufferedImage sourceImage, int maxWidth, double aspectRatio) {
        int width;
        double resizeRatio;
        if (sourceImage.getWidth() > maxWidth) {
            resizeRatio = (double)maxWidth / (double)sourceImage.getWidth();
            width = maxWidth;
        } else {
            resizeRatio = 1.0;
            width = sourceImage.getWidth();
        }
        int height = (int)Math.ceil(resizeRatio * aspectRatio * (double)sourceImage.getHeight());
        Image image = sourceImage.getScaledInstance(width, height, 1);
        BufferedImage resizedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 1);
        resizedImage.getGraphics().drawImage(image, 0, 0, null);
        return resizedImage;
    }

    private static double getColorDistanceCIE94(Color color1, Color color2) {
        float[] lab1 = ImageBanner.toLab(color1);
        float[] lab2 = ImageBanner.toLab(color2);
        double L1 = lab1[0];
        double a1 = lab1[1];
        double b1 = lab1[2];
        double L2 = lab2[0];
        double a2 = lab2[1];
        double b2 = lab2[2];
        double kL = 1.0;
        double K1 = 0.045;
        double K2 = 0.015;
        double sl = 1.0;
        double kc = 1.0;
        double kh = 1.0;
        double c1 = Math.sqrt(a1 * a1 + b1 * b1);
        double deltaC = c1 - Math.sqrt(a2 * a2 + b2 * b2);
        double deltaA = a1 - a2;
        double deltaB = b1 - b2;
        double deltaH = Math.sqrt(Math.max(0.0, deltaA * deltaA + deltaB * deltaB - deltaC * deltaC));
        return Math.sqrt(Math.max(0.0, Math.pow((L1 - L2) / (kL * sl), 2.0) + Math.pow(deltaC / (kc * (1.0 + K1 * c1)), 2.0) + Math.pow(deltaH / (kh * (1.0 + K2 * c1)), 2.0)));
    }

    static float[] toLab(Color color) {
        float[] xyz = color.getColorComponents(ColorSpace.getInstance(1001), null);
        return ImageBanner.xyzToLab(xyz);
    }

    static float[] xyzToLab(float[] colorvalue) {
        double l = ImageBanner.f(colorvalue[1]);
        double L = 116.0 * l - 16.0;
        double a = 500.0 * (ImageBanner.f(colorvalue[0]) - l);
        double b = 200.0 * (l - ImageBanner.f(colorvalue[2]));
        return new float[]{(float)L, (float)a, (float)b};
    }

    private static double f(double t) {
        if (t > 0.008856451679035631) {
            return Math.cbrt(t);
        }
        return 0.3333333333333333 * Math.pow(4.833333333333333, 2.0) * t + 0.13793103448275862;
    }

    private void colorsInit() {
        this.colors.put("BLACK", new Color(0, 0, 0));
        this.colors.put("RED", new Color(170, 0, 0));
        this.colors.put("GREEN", new Color(0, 170, 0));
        this.colors.put("YELLOW", new Color(170, 85, 0));
        this.colors.put("BLUE", new Color(0, 0, 170));
        this.colors.put("MAGENTA", new Color(170, 0, 170));
        this.colors.put("CYAN", new Color(0, 170, 170));
        this.colors.put("WHITE", new Color(170, 170, 170));
        this.colors.put("BRIGHT_BLACK", new Color(85, 85, 85));
        this.colors.put("BRIGHT_RED", new Color(255, 85, 85));
        this.colors.put("BRIGHT_GREEN", new Color(85, 255, 85));
        this.colors.put("BRIGHT_YELLOW", new Color(255, 255, 85));
        this.colors.put("BRIGHT_BLUE", new Color(85, 85, 255));
        this.colors.put("BRIGHT_MAGENTA", new Color(255, 85, 255));
        this.colors.put("BRIGHT_CYAN", new Color(85, 255, 255));
        this.colors.put("BRIGHT_WHITE", new Color(255, 255, 255));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String printBanner(Integer maxWidth, Double aspectRatio, boolean invert, boolean cie94) {
        String headlessProperty = System.getProperty("java.awt.headless");
        String banner = "";
        try {
            System.setProperty("java.awt.headless", "true");
            BufferedImage sourceImage = ImageIO.read(new FileInputStream(this.image));
            BufferedImage resizedImage = ImageBanner.resizeImage(sourceImage, maxWidth, aspectRatio);
            banner = this.imageToBanner(resizedImage, invert, cie94);
        }
        catch (Exception ex) {
            Logger.warn((String)("WARNING ! Image banner not printable: " + this.image + " (" + ex.getClass() + ": '" + ex.getMessage() + "')"), (Object[])new Object[0]);
            ex.printStackTrace();
        }
        finally {
            if (headlessProperty != null) {
                System.setProperty("java.awt.headless", headlessProperty);
            }
        }
        return banner;
    }

    private String imageToBanner(BufferedImage image, boolean dark, boolean cie94) {
        StringBuilder banner = new StringBuilder();
        for (int y = 0; y < image.getHeight(); ++y) {
            if (dark) {
                banner.append("${AnsiBackground.BLACK}");
            } else {
                banner.append("${AnsiBackground.DEFAULT}");
            }
            for (int x = 0; x < image.getWidth(); ++x) {
                Color color = new Color(image.getRGB(x, y), false);
                banner.append(this.getFormatString(color, dark, cie94));
            }
            if (dark) {
                banner.append("${AnsiBackground.DEFAULT}");
            }
            banner.append("${AnsiColor.DEFAULT}\n");
        }
        return banner.toString();
    }

    protected String getFormatString(Color color, boolean dark, boolean cie94) {
        String matchedColorName = null;
        Double minColorDistance = null;
        for (Map.Entry<String, Color> colorOption : this.colors.entrySet()) {
            double distance = cie94 ? ImageBanner.getColorDistanceCIE94(color, colorOption.getValue()) : ImageBanner.getColorDistance(color, colorOption.getValue());
            if (minColorDistance != null && !(distance < minColorDistance)) continue;
            minColorDistance = distance;
            matchedColorName = colorOption.getKey();
        }
        return "${AnsiColor." + matchedColorName + "}" + ImageBanner.getAsciiCharacter(color, dark);
    }
}

