/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.pager.plugin.PageInterceptor;
import org.aoju.bus.starter.mapper.ExplainSQLHandler;
import org.aoju.bus.starter.mapper.MybatisProperties;
import org.aoju.bus.starter.mapper.NatureSQLHandler;
import org.aoju.bus.starter.mapper.RecordTimeHandler;
import org.aoju.bus.starter.sensitive.SensitiveProperties;
import org.aoju.bus.starter.sensitive.SensitiveResultSetHandler;
import org.aoju.bus.starter.sensitive.SensitiveStatementHandler;
import org.apache.ibatis.plugin.Interceptor;

public class MybatisPluginBuilder {
    public static List<Interceptor> plugins = new ArrayList<Interceptor>();

    public static Interceptor[] build(MybatisProperties mybatisProperties, SensitiveProperties sensitiveProperties) {
        if (ObjectKit.isNotEmpty((Object)mybatisProperties)) {
            Properties p = new Properties();
            p.setProperty("autoDelimitKeywords", mybatisProperties.getAutoDelimitKeywords());
            p.setProperty("reasonable", mybatisProperties.getReasonable());
            p.setProperty("supportMethodsArguments", mybatisProperties.getSupportMethodsArguments());
            p.setProperty("returnPage", mybatisProperties.getReturnPage());
            p.setProperty("params", mybatisProperties.getParams());
            PageInterceptor interceptor = new PageInterceptor();
            interceptor.setProperties(p);
            ArrayList list = CollKit.newArrayList((Object[])new Interceptor[]{interceptor, new NatureSQLHandler(), new ExplainSQLHandler()});
            if (mybatisProperties.isRecordTime()) {
                list.add(new RecordTimeHandler());
            }
            if (ObjectKit.isNotEmpty((Object)sensitiveProperties)) {
                list.add(new SensitiveResultSetHandler(sensitiveProperties));
                list.add(new SensitiveStatementHandler(sensitiveProperties));
            }
            plugins.addAll(list);
        }
        return (Interceptor[])plugins.stream().toArray(Interceptor[]::new);
    }
}

