/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.cache;

import java.lang.reflect.Method;
import java.util.Map;
import org.aoju.bus.cache.CacheX;
import org.aoju.bus.cache.Complex;
import org.aoju.bus.cache.Context;
import org.aoju.bus.cache.Module;
import org.aoju.bus.cache.annotation.Cached;
import org.aoju.bus.cache.annotation.CachedGet;
import org.aoju.bus.cache.annotation.Invalid;
import org.aoju.bus.proxy.Factory;
import org.aoju.bus.proxy.Interceptor;
import org.aoju.bus.proxy.Invocation;
import org.aoju.bus.proxy.factory.cglib.CglibFactory;
import org.aoju.bus.proxy.invoker.JoinPointInvoker;
import org.aoju.bus.proxy.invoker.ProxyChain;
import org.springframework.beans.factory.FactoryBean;

public class CacheXProxy<T>
implements FactoryBean<T> {
    private Object target;
    private Object proxy;
    private Class<T> type;
    private Context.Switch cglib = Context.Switch.OFF;
    private Complex cacheCore;
    private Interceptor interceptor = new Interceptor(){

        public Object intercept(Invocation invocation) throws Throwable {
            Method method = invocation.getMethod();
            Cached cached = method.getAnnotation(Cached.class);
            if (null != cached) {
                return CacheXProxy.this.cacheCore.readWrite(cached, method, (ProxyChain)new JoinPointInvoker(CacheXProxy.this.target, invocation));
            }
            CachedGet cachedGet = method.getAnnotation(CachedGet.class);
            if (null != cachedGet) {
                return CacheXProxy.this.cacheCore.read(cachedGet, method, (ProxyChain)new JoinPointInvoker(CacheXProxy.this.target, invocation));
            }
            Invalid invalid = method.getAnnotation(Invalid.class);
            if (null != invalid) {
                CacheXProxy.this.cacheCore.remove(invalid, method, invocation.getArguments());
                return null;
            }
            return invocation.proceed();
        }
    };

    public CacheXProxy(Object target, Map<String, CacheX> caches) {
        this(target, target.getClass().getInterfaces()[0], caches, Context.Switch.OFF);
    }

    public CacheXProxy(Object target, Class<T> type, Map<String, CacheX> caches, Context.Switch cglib) {
        this.target = target;
        this.type = type;
        this.cglib = cglib;
        this.proxy = this.newProxy();
        this.cacheCore = Module.coreInstance((Context)Context.newConfig(caches));
    }

    private Object newProxy() {
        Object factory = this.cglib == Context.Switch.ON || !this.type.isInterface() ? new CglibFactory() : new Factory();
        return factory.createInterceptorProxy(this.target, this.interceptor, new Class[]{this.type});
    }

    public T getObject() {
        return (T)this.proxy;
    }

    public Class<T> getObjectType() {
        return this.type;
    }

    public boolean isSingleton() {
        return true;
    }
}

