/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.aoju.bus.core.toolkit.CollKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.pager.plugins.PageSqlHandler;
import org.aoju.bus.spring.PlaceBinder;
import org.aoju.bus.starter.mapper.ExplainSqlHandler;
import org.aoju.bus.starter.mapper.MybatisProperties;
import org.aoju.bus.starter.mapper.NatureSqlHandler;
import org.aoju.bus.starter.sensitive.SensitiveProperties;
import org.aoju.bus.starter.sensitive.SensitiveResultSetHandler;
import org.aoju.bus.starter.sensitive.SensitiveStatementHandler;
import org.apache.ibatis.plugin.Interceptor;
import org.springframework.core.env.Environment;

public class MybatisPluginBuilder {
    public static List<Interceptor> plugins = new ArrayList<Interceptor>();

    public static Interceptor[] build(Environment environment) {
        ArrayList list = CollKit.newArrayList((Object[])new Interceptor[]{new NatureSqlHandler(), new ExplainSqlHandler()});
        if (ObjectKit.isNotEmpty((Object)environment)) {
            SensitiveProperties sensitiveProperties;
            MybatisProperties mybatisProperties = (MybatisProperties)PlaceBinder.bind((Environment)environment, MybatisProperties.class, (String)"extend.mybatis");
            if (ObjectKit.isNotEmpty((Object)mybatisProperties)) {
                Properties p = new Properties();
                p.setProperty("autoDelimitKeywords", mybatisProperties.getAutoDelimitKeywords());
                p.setProperty("reasonable", mybatisProperties.getReasonable());
                p.setProperty("supportMethodsArguments", mybatisProperties.getSupportMethodsArguments());
                p.setProperty("params", mybatisProperties.getParams());
                PageSqlHandler pageSqlHandler = new PageSqlHandler();
                pageSqlHandler.setProperties(p);
                list.add(pageSqlHandler);
            }
            if (ObjectKit.isNotEmpty((Object)(sensitiveProperties = (SensitiveProperties)PlaceBinder.bind((Environment)environment, SensitiveProperties.class, (String)"extend.mybatis")))) {
                Properties p = new Properties();
                p.setProperty("debug", String.valueOf(sensitiveProperties.isDebug()));
                p.setProperty("key", sensitiveProperties.getDecrypt().getKey());
                p.setProperty("type", sensitiveProperties.getDecrypt().getType());
                SensitiveResultSetHandler sensitiveResultSetHandler = new SensitiveResultSetHandler();
                sensitiveResultSetHandler.setProperties(p);
                list.add(sensitiveResultSetHandler);
                p.setProperty("key", sensitiveProperties.getEncrypt().getKey());
                p.setProperty("type", sensitiveProperties.getEncrypt().getType());
                SensitiveStatementHandler sensitiveStatementHandler = new SensitiveStatementHandler();
                sensitiveStatementHandler.setProperties(p);
                list.add(sensitiveStatementHandler);
            }
        }
        plugins.addAll(list);
        return (Interceptor[])plugins.stream().toArray(Interceptor[]::new);
    }
}

