/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.storage;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.cache.metric.ExtendCache;
import org.aoju.bus.core.exception.InstrumentException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.starter.storage.StorageProperties;
import org.aoju.bus.storage.Builder;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.Provider;
import org.aoju.bus.storage.Registry;
import org.aoju.bus.storage.metric.StorageCache;
import org.aoju.bus.storage.provider.AliYunOssProvider;
import org.aoju.bus.storage.provider.BaiduYunBosProvider;
import org.aoju.bus.storage.provider.HuaweiObsProvider;
import org.aoju.bus.storage.provider.JdYunOssProvider;
import org.aoju.bus.storage.provider.LocalFileProvider;
import org.aoju.bus.storage.provider.MinioOssProvider;
import org.aoju.bus.storage.provider.QiniuYunOssProvider;
import org.aoju.bus.storage.provider.TencentCosProvider;
import org.aoju.bus.storage.provider.UpyunOssProvider;

public class StorageProviderService {
    private static Map<Registry, Context> CACHE = new ConcurrentHashMap<Registry, Context>();
    public StorageProperties properties;
    public ExtendCache extendCache;

    public StorageProviderService(StorageProperties properties) {
        this(properties, (ExtendCache)StorageCache.INSTANCE);
    }

    public StorageProviderService(StorageProperties properties, ExtendCache extendCache) {
        this.properties = properties;
        this.extendCache = extendCache;
    }

    public static void register(Registry type, Context context) {
        if (CACHE.containsKey(type)) {
            throw new InstrumentException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + type.name());
        }
        CACHE.putIfAbsent(type, context);
    }

    public Provider require(Registry type) {
        Context context = CACHE.get(type);
        if (ObjectKit.isEmpty((Object)context)) {
            context = this.properties.getType().get(type);
        }
        if (Registry.ALIYUN.equals((Object)type)) {
            return new AliYunOssProvider(context);
        }
        if (Registry.BAIDU.equals((Object)type)) {
            return new BaiduYunBosProvider(context);
        }
        if (Registry.HUAWEI.equals((Object)type)) {
            return new HuaweiObsProvider(context);
        }
        if (Registry.JD.equals((Object)type)) {
            return new JdYunOssProvider(context);
        }
        if (Registry.MINIO.equals((Object)type)) {
            return new MinioOssProvider(context);
        }
        if (Registry.QINIU.equals((Object)type)) {
            return new QiniuYunOssProvider(context);
        }
        if (Registry.TENCENT.equals((Object)type)) {
            return new TencentCosProvider(context);
        }
        if (Registry.UPYUN.equals((Object)type)) {
            return new UpyunOssProvider(context);
        }
        if (Registry.LOCAL.equals((Object)type)) {
            return new LocalFileProvider(context);
        }
        throw new InstrumentException(Builder.ErrorCode.UNSUPPORTED.getMsg());
    }
}

