/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.ExecutorType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;

@ConfigurationProperties(prefix="extend.mybatis")
public class MybatisProperties {
    private static final ResourcePatternResolver resourceResolver = new PathMatchingResourcePatternResolver();
    private String[] basePackages;
    private String configLocation;
    private String[] mapperLocations;
    private String typeAliasesPackage;
    private Class<?> typeAliasesSuperType;
    private String typeHandlersPackage;
    private boolean checkConfigLocation = false;
    private ExecutorType executorType;
    private Properties configurationProperties;
    @NestedConfigurationProperty
    private Configuration configuration;
    private String params;
    private String autoDelimitKeywords;
    private String reasonable;
    private String supportMethodsArguments;

    public Resource[] resolveMapperLocations() {
        ArrayList<Resource> resources = new ArrayList<Resource>();
        if (this.mapperLocations != null) {
            for (String mapperLocation : this.mapperLocations) {
                resources.addAll(Arrays.asList(this.getResources(mapperLocation)));
            }
        }
        return resources.toArray(new Resource[resources.size()]);
    }

    private Resource[] getResources(String location) {
        try {
            return resourceResolver.getResources(location);
        }
        catch (IOException e) {
            return new Resource[0];
        }
    }

    public String[] getBasePackages() {
        return this.basePackages;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public String[] getMapperLocations() {
        return this.mapperLocations;
    }

    public String getTypeAliasesPackage() {
        return this.typeAliasesPackage;
    }

    public Class<?> getTypeAliasesSuperType() {
        return this.typeAliasesSuperType;
    }

    public String getTypeHandlersPackage() {
        return this.typeHandlersPackage;
    }

    public boolean isCheckConfigLocation() {
        return this.checkConfigLocation;
    }

    public ExecutorType getExecutorType() {
        return this.executorType;
    }

    public Properties getConfigurationProperties() {
        return this.configurationProperties;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public String getParams() {
        return this.params;
    }

    public String getAutoDelimitKeywords() {
        return this.autoDelimitKeywords;
    }

    public String getReasonable() {
        return this.reasonable;
    }

    public String getSupportMethodsArguments() {
        return this.supportMethodsArguments;
    }

    public void setBasePackages(String[] basePackages) {
        this.basePackages = basePackages;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public void setMapperLocations(String[] mapperLocations) {
        this.mapperLocations = mapperLocations;
    }

    public void setTypeAliasesPackage(String typeAliasesPackage) {
        this.typeAliasesPackage = typeAliasesPackage;
    }

    public void setTypeAliasesSuperType(Class<?> typeAliasesSuperType) {
        this.typeAliasesSuperType = typeAliasesSuperType;
    }

    public void setTypeHandlersPackage(String typeHandlersPackage) {
        this.typeHandlersPackage = typeHandlersPackage;
    }

    public void setCheckConfigLocation(boolean checkConfigLocation) {
        this.checkConfigLocation = checkConfigLocation;
    }

    public void setExecutorType(ExecutorType executorType) {
        this.executorType = executorType;
    }

    public void setConfigurationProperties(Properties configurationProperties) {
        this.configurationProperties = configurationProperties;
    }

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    public void setParams(String params) {
        this.params = params;
    }

    public void setAutoDelimitKeywords(String autoDelimitKeywords) {
        this.autoDelimitKeywords = autoDelimitKeywords;
    }

    public void setReasonable(String reasonable) {
        this.reasonable = reasonable;
    }

    public void setSupportMethodsArguments(String supportMethodsArguments) {
        this.supportMethodsArguments = supportMethodsArguments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MybatisProperties)) {
            return false;
        }
        MybatisProperties other = (MybatisProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isCheckConfigLocation() != other.isCheckConfigLocation()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getBasePackages(), other.getBasePackages())) {
            return false;
        }
        String this$configLocation = this.getConfigLocation();
        String other$configLocation = other.getConfigLocation();
        if (this$configLocation == null ? other$configLocation != null : !this$configLocation.equals(other$configLocation)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getMapperLocations(), other.getMapperLocations())) {
            return false;
        }
        String this$typeAliasesPackage = this.getTypeAliasesPackage();
        String other$typeAliasesPackage = other.getTypeAliasesPackage();
        if (this$typeAliasesPackage == null ? other$typeAliasesPackage != null : !this$typeAliasesPackage.equals(other$typeAliasesPackage)) {
            return false;
        }
        Class<?> this$typeAliasesSuperType = this.getTypeAliasesSuperType();
        Class<?> other$typeAliasesSuperType = other.getTypeAliasesSuperType();
        if (this$typeAliasesSuperType == null ? other$typeAliasesSuperType != null : !this$typeAliasesSuperType.equals(other$typeAliasesSuperType)) {
            return false;
        }
        String this$typeHandlersPackage = this.getTypeHandlersPackage();
        String other$typeHandlersPackage = other.getTypeHandlersPackage();
        if (this$typeHandlersPackage == null ? other$typeHandlersPackage != null : !this$typeHandlersPackage.equals(other$typeHandlersPackage)) {
            return false;
        }
        ExecutorType this$executorType = this.getExecutorType();
        ExecutorType other$executorType = other.getExecutorType();
        if (this$executorType == null ? other$executorType != null : !this$executorType.equals(other$executorType)) {
            return false;
        }
        Properties this$configurationProperties = this.getConfigurationProperties();
        Properties other$configurationProperties = other.getConfigurationProperties();
        if (this$configurationProperties == null ? other$configurationProperties != null : !((Object)this$configurationProperties).equals(other$configurationProperties)) {
            return false;
        }
        Configuration this$configuration = this.getConfiguration();
        Configuration other$configuration = other.getConfiguration();
        if (this$configuration == null ? other$configuration != null : !this$configuration.equals(other$configuration)) {
            return false;
        }
        String this$params = this.getParams();
        String other$params = other.getParams();
        if (this$params == null ? other$params != null : !this$params.equals(other$params)) {
            return false;
        }
        String this$autoDelimitKeywords = this.getAutoDelimitKeywords();
        String other$autoDelimitKeywords = other.getAutoDelimitKeywords();
        if (this$autoDelimitKeywords == null ? other$autoDelimitKeywords != null : !this$autoDelimitKeywords.equals(other$autoDelimitKeywords)) {
            return false;
        }
        String this$reasonable = this.getReasonable();
        String other$reasonable = other.getReasonable();
        if (this$reasonable == null ? other$reasonable != null : !this$reasonable.equals(other$reasonable)) {
            return false;
        }
        String this$supportMethodsArguments = this.getSupportMethodsArguments();
        String other$supportMethodsArguments = other.getSupportMethodsArguments();
        return !(this$supportMethodsArguments == null ? other$supportMethodsArguments != null : !this$supportMethodsArguments.equals(other$supportMethodsArguments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MybatisProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isCheckConfigLocation() ? 79 : 97);
        result = result * 59 + Arrays.deepHashCode(this.getBasePackages());
        String $configLocation = this.getConfigLocation();
        result = result * 59 + ($configLocation == null ? 43 : $configLocation.hashCode());
        result = result * 59 + Arrays.deepHashCode(this.getMapperLocations());
        String $typeAliasesPackage = this.getTypeAliasesPackage();
        result = result * 59 + ($typeAliasesPackage == null ? 43 : $typeAliasesPackage.hashCode());
        Class<?> $typeAliasesSuperType = this.getTypeAliasesSuperType();
        result = result * 59 + ($typeAliasesSuperType == null ? 43 : $typeAliasesSuperType.hashCode());
        String $typeHandlersPackage = this.getTypeHandlersPackage();
        result = result * 59 + ($typeHandlersPackage == null ? 43 : $typeHandlersPackage.hashCode());
        ExecutorType $executorType = this.getExecutorType();
        result = result * 59 + ($executorType == null ? 43 : $executorType.hashCode());
        Properties $configurationProperties = this.getConfigurationProperties();
        result = result * 59 + ($configurationProperties == null ? 43 : ((Object)$configurationProperties).hashCode());
        Configuration $configuration = this.getConfiguration();
        result = result * 59 + ($configuration == null ? 43 : $configuration.hashCode());
        String $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : $params.hashCode());
        String $autoDelimitKeywords = this.getAutoDelimitKeywords();
        result = result * 59 + ($autoDelimitKeywords == null ? 43 : $autoDelimitKeywords.hashCode());
        String $reasonable = this.getReasonable();
        result = result * 59 + ($reasonable == null ? 43 : $reasonable.hashCode());
        String $supportMethodsArguments = this.getSupportMethodsArguments();
        result = result * 59 + ($supportMethodsArguments == null ? 43 : $supportMethodsArguments.hashCode());
        return result;
    }

    public String toString() {
        return "MybatisProperties(basePackages=" + Arrays.deepToString(this.getBasePackages()) + ", configLocation=" + this.getConfigLocation() + ", mapperLocations=" + Arrays.deepToString(this.getMapperLocations()) + ", typeAliasesPackage=" + this.getTypeAliasesPackage() + ", typeAliasesSuperType=" + String.valueOf(this.getTypeAliasesSuperType()) + ", typeHandlersPackage=" + this.getTypeHandlersPackage() + ", checkConfigLocation=" + this.isCheckConfigLocation() + ", executorType=" + String.valueOf(this.getExecutorType()) + ", configurationProperties=" + String.valueOf(this.getConfigurationProperties()) + ", configuration=" + String.valueOf(this.getConfiguration()) + ", params=" + this.getParams() + ", autoDelimitKeywords=" + this.getAutoDelimitKeywords() + ", reasonable=" + this.getReasonable() + ", supportMethodsArguments=" + this.getSupportMethodsArguments() + ")";
    }
}

