/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.spring.banner;

import java.io.Closeable;
import java.io.InputStream;
import org.aoju.bus.core.toolkit.IoKit;

public abstract class AbstractBanner {
    protected Class<?> resourceClass;
    protected String resourceLocation;
    protected String defaultBanner;
    protected String banner;

    public AbstractBanner(Class<?> resourceClass, String resourceLocation, String defaultBanner) {
        this.resourceClass = resourceClass;
        this.resourceLocation = resourceLocation;
        this.defaultBanner = defaultBanner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialize() {
        InputStream inputStream = null;
        String bannerText = null;
        try {
            if (null != this.resourceLocation) {
                inputStream = this.resourceClass.getResourceAsStream(this.resourceLocation);
                bannerText = IoKit.toString((InputStream)inputStream, (String)"UTF-8");
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.banner = this.generateBanner(bannerText);
            if (null != inputStream) {
                IoKit.close((Closeable)inputStream);
            }
        }
    }

    public String getBanner() {
        return this.banner;
    }

    public String getPlainBanner() {
        if (null != this.banner) {
            this.banner = this.banner.replaceAll("\u001b\\[[;\\d]*m", "");
        }
        return this.banner;
    }

    protected abstract String generateBanner(String var1);
}

