/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.cors;

import jakarta.annotation.Resource;
import java.util.Arrays;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.starter.cors.CorsProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;

@EnableConfigurationProperties(value={CorsProperties.class})
public class CorsConfiguration {
    @Resource
    CorsProperties properties;

    @Bean
    @ConditionalOnMissingBean
    public CorsFilter corsFilter() {
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration(this.properties.getPath(), this.buildConfig());
        return new CorsFilter((CorsConfigurationSource)source);
    }

    private org.springframework.web.cors.CorsConfiguration buildConfig() {
        org.springframework.web.cors.CorsConfiguration corsConfiguration = new org.springframework.web.cors.CorsConfiguration();
        corsConfiguration.setAllowedOrigins(Arrays.asList(this.properties.getAllowedOrigins()));
        corsConfiguration.setAllowedHeaders(Arrays.asList(this.properties.getAllowedHeaders()));
        corsConfiguration.setAllowedMethods(Arrays.asList(this.properties.getAllowedMethods()));
        corsConfiguration.setAllowCredentials(this.properties.getAllowCredentials());
        if (ObjectKit.isNotNull((Object)this.properties.getMaxAge())) {
            corsConfiguration.setMaxAge(this.properties.getMaxAge());
        }
        if (ArrayKit.isNotEmpty((Object[])this.properties.getExposedHeaders())) {
            corsConfiguration.setExposedHeaders(Arrays.asList(this.properties.getExposedHeaders()));
        }
        return corsConfiguration;
    }
}

