/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.notify;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.notify.Builder;
import org.aoju.bus.notify.Context;
import org.aoju.bus.notify.Provider;
import org.aoju.bus.notify.Registry;
import org.aoju.bus.notify.provider.aliyun.AliyunEmailProvider;
import org.aoju.bus.notify.provider.aliyun.AliyunSmsProvider;
import org.aoju.bus.notify.provider.aliyun.AliyunVmsProvider;
import org.aoju.bus.notify.provider.baidu.BaiduSmsProvider;
import org.aoju.bus.notify.provider.dingtalk.DingTalkProvider;
import org.aoju.bus.notify.provider.generic.GenericEmailProvider;
import org.aoju.bus.notify.provider.huawei.HuaweiSmsProvider;
import org.aoju.bus.notify.provider.jdcloud.JdcloudSmsProvider;
import org.aoju.bus.notify.provider.jpush.JpushSmsProvider;
import org.aoju.bus.notify.provider.netease.NeteaseSmsProvider;
import org.aoju.bus.notify.provider.qiniu.QiniuSmsProvider;
import org.aoju.bus.notify.provider.tencent.TencentSmsProvider;
import org.aoju.bus.notify.provider.upyun.UpyunSmsProvider;
import org.aoju.bus.notify.provider.wechat.WechatCpProvider;
import org.aoju.bus.notify.provider.wechat.WechatKfProvider;
import org.aoju.bus.notify.provider.wechat.WechatMiniProvider;
import org.aoju.bus.notify.provider.wechat.WechatMpProvider;
import org.aoju.bus.notify.provider.yunpian.YunpianSmsProvider;
import org.aoju.bus.starter.notify.NotifyProperties;

public class NotifyProviderService {
    private static Map<Registry, Context> CACHE = new ConcurrentHashMap<Registry, Context>();
    public NotifyProperties properties;

    public NotifyProviderService(NotifyProperties properties) {
        this.properties = properties;
    }

    public static void register(Registry registry, Context context) {
        if (CACHE.containsKey(registry)) {
            throw new InternalException("\u91cd\u590d\u6ce8\u518c\u540c\u540d\u79f0\u7684\u7ec4\u4ef6\uff1a" + registry.name());
        }
        CACHE.putIfAbsent(registry, context);
    }

    public Provider require(Registry registry) {
        Context context = CACHE.get(registry);
        if (ObjectKit.isEmpty((Object)context)) {
            context = this.properties.getType().get(registry);
        }
        if (Registry.ALIYUN_SMS.equals((Object)registry)) {
            return new AliyunSmsProvider(context);
        }
        if (Registry.ALIYUN_VMS.equals((Object)registry)) {
            return new AliyunVmsProvider(context);
        }
        if (Registry.ALIYUN_EDM.equals((Object)registry)) {
            return new AliyunEmailProvider(context);
        }
        if (Registry.BAIDU_SMS.equals((Object)registry)) {
            return new BaiduSmsProvider(context);
        }
        if (Registry.DINGTALK.equals((Object)registry)) {
            return new DingTalkProvider(context);
        }
        if (Registry.GENERIC_EDM.equals((Object)registry)) {
            return new GenericEmailProvider(context);
        }
        if (Registry.HUAWEI_SMS.equals((Object)registry)) {
            return new HuaweiSmsProvider(context);
        }
        if (Registry.JDCLOUD_SMS.equals((Object)registry)) {
            return new JdcloudSmsProvider(context);
        }
        if (Registry.JPUSH_SMS.equals((Object)registry)) {
            return new JpushSmsProvider(context);
        }
        if (Registry.NETEASE_SMS.equals((Object)registry)) {
            return new NeteaseSmsProvider(context);
        }
        if (Registry.QINIU_SMS.equals((Object)registry)) {
            return new QiniuSmsProvider(context);
        }
        if (Registry.TENCENT_SMS.equals((Object)registry)) {
            return new TencentSmsProvider(context);
        }
        if (Registry.UPYUN_SMS.equals((Object)registry)) {
            return new UpyunSmsProvider(context);
        }
        if (Registry.WECHAT_CP.equals((Object)registry)) {
            return new WechatCpProvider(context);
        }
        if (Registry.WECHAT_KF.equals((Object)registry)) {
            return new WechatKfProvider(context);
        }
        if (Registry.WECHAT_MINI.equals((Object)registry)) {
            return new WechatMiniProvider(context);
        }
        if (Registry.WECHAT_MP.equals((Object)registry)) {
            return new WechatMpProvider(context);
        }
        if (Registry.YUNPIAN_SMS.equals((Object)registry)) {
            return new YunpianSmsProvider(context);
        }
        throw new InternalException(Builder.ErrorCode.UNSUPPORTED.getMsg());
    }
}

