/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.sensitive;

import jakarta.annotation.Resource;
import java.io.InputStream;
import java.lang.reflect.Type;
import org.aoju.bus.base.advice.BaseAdvice;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.starter.sensitive.SensitiveProperties;
import org.springframework.core.MethodParameter;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpInputMessage;
import org.springframework.http.converter.HttpMessageConverter;

public class RequestBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.RequestBodyAdvice {
    @Resource
    SensitiveProperties properties;

    public boolean supports(MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        Object[] annotations = parameter.getDeclaringClass().getAnnotations();
        if (ArrayKit.isNotEmpty((Object[])annotations)) {
            for (Object annotation : annotations) {
                if (!(annotation instanceof Sensitive)) continue;
                return true;
            }
        }
        return parameter.getMethod().isAnnotationPresent(Sensitive.class);
    }

    public HttpInputMessage beforeBodyRead(HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        if (ObjectKit.isNotEmpty((Object)this.properties) && !this.properties.isDebug()) {
            try {
                Sensitive sensitive = parameter.getMethod().getAnnotation(Sensitive.class);
                if (ObjectKit.isEmpty((Object)sensitive)) {
                    return inputMessage;
                }
                if ("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "IN".equals(sensitive.stage()))) {
                    inputMessage = new InputMessage(inputMessage, this.properties.getDecrypt().getKey(), this.properties.getDecrypt().getType(), "UTF-8");
                }
            }
            catch (Exception e) {
                Logger.error((String)("Internal processing failure:" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return inputMessage;
    }

    public Object afterBodyRead(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    public Object handleEmptyBody(Object body, HttpInputMessage inputMessage, MethodParameter parameter, Type type, Class<? extends HttpMessageConverter<?>> converterType) {
        return body;
    }

    class InputMessage
    implements HttpInputMessage {
        private HttpHeaders headers;
        private InputStream body;

        public InputMessage(HttpInputMessage inputMessage, String key, String type, String charset) throws Exception {
            String decryptBody;
            if (StringKit.isEmpty((CharSequence)key)) {
                throw new NullPointerException("Please check the request.crypto.decrypt");
            }
            this.headers = inputMessage.getHeaders();
            String content = IoKit.toString((InputStream)inputMessage.getBody(), (String)charset);
            if (content.startsWith("{")) {
                decryptBody = content;
            } else {
                StringBuilder json = new StringBuilder();
                if (!StringKit.isEmpty((CharSequence)(content = content.replaceAll(" ", "+")))) {
                    Logger.debug((String)"Request data decryption enabled ...", (Object[])new Object[0]);
                    String[] contents = content.split("\\|");
                    for (int k = 0; k < contents.length; ++k) {
                        json.append(Builder.decrypt((String)type, (String)key, (String)contents[k], (java.nio.charset.Charset)Charset.UTF_8));
                    }
                }
                decryptBody = json.toString();
            }
            this.body = IoKit.toInputStream((String)decryptBody, (String)charset);
        }

        public InputStream getBody() {
            return this.body;
        }

        public HttpHeaders getHeaders() {
            return this.headers;
        }
    }
}

