/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.sensitive;

import jakarta.annotation.Resource;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.aoju.bus.base.advice.BaseAdvice;
import org.aoju.bus.base.entity.Message;
import org.aoju.bus.base.entity.Result;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.core.lang.Charset;
import org.aoju.bus.core.toolkit.ArrayKit;
import org.aoju.bus.core.toolkit.ObjectKit;
import org.aoju.bus.core.toolkit.ReflectKit;
import org.aoju.bus.core.toolkit.StringKit;
import org.aoju.bus.crypto.Builder;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.sensitive.annotation.Privacy;
import org.aoju.bus.sensitive.annotation.Sensitive;
import org.aoju.bus.starter.sensitive.SensitiveProperties;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;

public class ResponseBodyAdvice
extends BaseAdvice
implements org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice<Object> {
    @Resource
    SensitiveProperties properties;

    private static <T> void setValue(T entity, String[] fields, Object[] value) {
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            if (!ReflectKit.hasField(entity, (String)field)) continue;
            ReflectKit.invokeSetter(entity, (String)field, (Object)value[i]);
        }
    }

    private static <T> Object getValue(T entity, String field) {
        if (ReflectKit.hasField(entity, (String)field)) {
            Object object = ReflectKit.invokeGetter(entity, (String)field);
            return null != object ? object.toString() : null;
        }
        return null;
    }

    public boolean supports(MethodParameter returnType, Class<? extends HttpMessageConverter<?>> converterType) {
        Object[] annotations = returnType.getDeclaringClass().getAnnotations();
        if (ArrayKit.isNotEmpty((Object[])annotations)) {
            for (Object annotation : annotations) {
                if (!(annotation instanceof Sensitive)) continue;
                return true;
            }
        }
        return returnType.getMethod().isAnnotationPresent(Sensitive.class);
    }

    public Object beforeBodyWrite(Object body, MethodParameter parameter, MediaType mediaType, Class<? extends HttpMessageConverter<?>> converterType, ServerHttpRequest request, ServerHttpResponse response) {
        if (ObjectKit.isNotEmpty((Object)this.properties) && !this.properties.isDebug()) {
            try {
                Sensitive sensitive = parameter.getMethod().getAnnotation(Sensitive.class);
                if (ObjectKit.isEmpty((Object)sensitive)) {
                    return body;
                }
                Object object = ((Message)body).getData();
                if (object instanceof Result) {
                    ArrayList list = new ArrayList();
                    for (Object value : ((Result)object).getRows()) {
                        this.beforeBodyWrite(sensitive, value);
                        list.add(value);
                    }
                    ((Result)((Message)body).getData()).setRows(list);
                } else if (object instanceof List) {
                    ArrayList list = new ArrayList();
                    for (Object value : (List)object) {
                        this.beforeBodyWrite(sensitive, value);
                        list.add(value);
                    }
                    ((Message)body).setData(list);
                } else {
                    this.beforeBodyWrite(sensitive, object);
                    ((Message)body).setData(object);
                }
            }
            catch (Exception e) {
                Logger.error((String)("Internal processing failure:" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return body;
    }

    private void beforeBodyWrite(Sensitive sensitive, Object object) {
        if (ObjectKit.isEmpty((Object)object)) {
            return;
        }
        if (("ALL".equals(sensitive.value()) || "SENS".equals(sensitive.value())) && ("ALL".equals(sensitive.stage()) || "OUT".equals(sensitive.stage()))) {
            Logger.debug((String)"Response data sensitive enabled ...", (Object[])new Object[0]);
            org.aoju.bus.sensitive.Builder.on((Object)object, (Annotation)sensitive);
        }
        if ("ALL".equals(sensitive.value()) || "SAFE".equals(sensitive.value()) && ("ALL".equals(sensitive.stage()) || "OUT".equals(sensitive.stage()))) {
            Map<String, Privacy> map = this.getPrivacyMap(object.getClass());
            for (Map.Entry<String, Privacy> entry : map.entrySet()) {
                String property;
                String value;
                Privacy privacy = entry.getValue();
                if (!ObjectKit.isNotEmpty((Object)privacy) || !StringKit.isNotEmpty((CharSequence)privacy.value()) || !"ALL".equals(privacy.value()) && !"OUT".equals(privacy.value()) || !StringKit.isNotEmpty((CharSequence)(value = (String)ResponseBodyAdvice.getValue(object, property = entry.getKey())))) continue;
                if (ObjectKit.isEmpty((Object)this.properties)) {
                    throw new InternalException("Please check the request.crypto.encrypt");
                }
                Logger.debug((String)"Response data encryption enabled ...", (Object[])new Object[0]);
                value = Builder.encrypt((String)this.properties.getEncrypt().getType(), (String)this.properties.getEncrypt().getKey(), (String)value, (java.nio.charset.Charset)Charset.UTF_8);
                ResponseBodyAdvice.setValue(object, new String[]{property}, new String[]{value});
            }
        }
    }

    private Map<String, Privacy> getPrivacyMap(Class<?> clazz) {
        HashMap<String, Privacy> map = new HashMap<String, Privacy>();
        for (Field field : clazz.getDeclaredFields()) {
            Privacy privacy = field.getAnnotation(Privacy.class);
            if (null == privacy) continue;
            map.put(field.getName(), privacy);
        }
        return map;
    }
}

