/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.tracer;

import jakarta.annotation.Resource;
import java.util.concurrent.Executor;
import org.aoju.bus.starter.tracer.TracerProperties;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Tracer;
import org.aoju.bus.tracer.binding.spring.context.PostTpicAsyncBeanPostProcessor;
import org.aoju.bus.tracer.binding.spring.context.PreTpicAsyncBeanPostProcessor;
import org.aoju.bus.tracer.binding.spring.http.TraceClientHttpRequestInterceptor;
import org.aoju.bus.tracer.binding.spring.web.TraceInterceptor;
import org.aoju.bus.tracer.binding.spring.web.TraceResponseBodyAdvice;
import org.aoju.bus.tracer.config.TraceFilterConfig;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Role;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@ConditionalOnWebApplication
@ConditionalOnClass(value={Tracer.class, RestTemplate.class})
@ConditionalOnBean(value={AsyncTaskExecutor.class, RestTemplate.class})
@EnableConfigurationProperties(value={TracerProperties.class})
@AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
public class TracerConfiguration {
    @Resource
    TracerProperties properties;
    @Resource
    Backend backend;

    @Bean
    WebMvcConfigurer traceSpringMvcWebMvcConfigurerAdapter() {
        return new WebMvcConfigurer(){

            public void addInterceptors(InterceptorRegistry registry) {
                registry.addInterceptor((HandlerInterceptor)new TraceInterceptor(TracerConfiguration.this.backend));
            }
        };
    }

    @Bean
    public PreTpicAsyncBeanPostProcessor preTpicAsyncBeanPostProcessor(AsyncTaskExecutor executor, Backend backend) {
        return new PreTpicAsyncBeanPostProcessor((Executor)executor, backend);
    }

    @Bean
    public PostTpicAsyncBeanPostProcessor postTpicAsyncBeanPostProcessor(AsyncTaskExecutor executor, Backend backend) {
        return new PostTpicAsyncBeanPostProcessor((Executor)executor, backend);
    }

    @Bean
    TraceResponseBodyAdvice TraceSpringMvcResponseBodyAdvice() {
        return new TraceResponseBodyAdvice();
    }

    @Role(value=2)
    @Bean
    TraceClientHttpRequestInterceptor TraceClientHttpRequestInterceptor(Backend Backend2) {
        return new TraceClientHttpRequestInterceptor(Backend2, new HttpHeaderTransport(), "default");
    }

    @Role(value=2)
    @Bean
    BeanPostProcessor restTemplatePostProcessor(TraceClientHttpRequestInterceptor TraceClientHttpRequestInterceptor2) {
        return new RestTemplatePostProcessor(TraceClientHttpRequestInterceptor2);
    }

    private static class RestTemplatePostProcessor
    implements BeanPostProcessor {
        private final TraceClientHttpRequestInterceptor interceptor;

        private RestTemplatePostProcessor(TraceClientHttpRequestInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof RestTemplate) {
                ((RestTemplate)bean).getInterceptors().add(this.interceptor);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }

    @ConditionalOnMissingBean(value={TraceFilterConfig.class})
    public static class TracePropertiesConfig {
        @Bean
        @Role(value=1)
        public TraceFilterConfig filterConfiguration(TracerProperties properties) {
            return properties.getAsFilterConfiguration();
        }
    }
}

