/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.starter.wrapper;

import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.aoju.bus.core.lang.Normal;
import org.aoju.bus.core.toolkit.EscapeKit;
import org.aoju.bus.core.toolkit.IoKit;
import org.aoju.bus.extra.json.JsonKit;
import org.aoju.bus.logger.Logger;

public class CacheRequestWrapper
extends HttpServletRequestWrapper {
    private static final byte[] DEFAULT_BYTE = Normal.EMPTY_BYTE_ARRAY;
    private byte[] body;
    private ServletInputStreamWrapper inputStreamWrapper;

    CacheRequestWrapper(HttpServletRequest request) throws IOException {
        super(request);
        Logger.info((String)"{}", (Object[])new Object[]{JsonKit.toJsonString((Object)request.getParameterMap())});
        this.body = IoKit.readBytes((InputStream)request.getInputStream());
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(null != this.body ? this.body : DEFAULT_BYTE);
        this.inputStreamWrapper = new ServletInputStreamWrapper(byteArrayInputStream);
        this.inputStreamWrapper.setInputStream(byteArrayInputStream);
    }

    public byte[] getBody() {
        return this.body;
    }

    public ServletInputStream getInputStream() {
        return this.inputStreamWrapper;
    }

    public BufferedReader getReader() {
        return new BufferedReader(new InputStreamReader((InputStream)((Object)this.inputStreamWrapper)));
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (null == values || values.length <= 0) {
            return null;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            encodedValues[i] = values[i];
            if (JsonKit.isJson((String)values[i])) continue;
            encodedValues[i] = EscapeKit.escapeHtml4((String)values[i]);
        }
        return encodedValues;
    }

    public String getParameter(String name) {
        String content = super.getParameter(name);
        if (!JsonKit.isJson((String)content)) {
            content = EscapeKit.escapeHtml4((String)content);
        }
        return content;
    }

    public String getHeader(String name) {
        String content = super.getHeader(name);
        if (!JsonKit.isJson((String)content)) {
            content = EscapeKit.escapeHtml4((String)content);
        }
        return content;
    }

    private static class ServletInputStreamWrapper
    extends ServletInputStream {
        private InputStream inputStream;

        public boolean isFinished() {
            return true;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener readListener) {
        }

        public int read() throws IOException {
            return this.inputStream.read();
        }

        public InputStream getInputStream() {
            return this.inputStream;
        }

        public void setInputStream(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public String toString() {
            return "CacheRequestWrapper.ServletInputStreamWrapper(inputStream=" + String.valueOf(this.getInputStream()) + ")";
        }

        public ServletInputStreamWrapper(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ServletInputStreamWrapper)) {
                return false;
            }
            ServletInputStreamWrapper other = (ServletInputStreamWrapper)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            InputStream this$inputStream = this.getInputStream();
            InputStream other$inputStream = other.getInputStream();
            return !(this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ServletInputStreamWrapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            InputStream $inputStream = this.getInputStream();
            result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
            return result;
        }
    }
}

