/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.magic;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.storage.magic.MagicDetector;
import org.aoju.bus.storage.magic.MagicMatch;

public class MagicMatcher
implements Cloneable {
    private List<MagicMatcher> subMatchers = new ArrayList<MagicMatcher>(0);
    private MagicMatch match = null;

    public MagicMatch getMatch() {
        return this.match;
    }

    public void setMatch(MagicMatch match) {
        this.match = match;
    }

    public boolean isValid() {
        if (this.match == null || this.match.getTest() == null) {
            return false;
        }
        String type = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        String description = this.match.getDescription();
        String test = new String(this.match.getTest().array());
        return type != null && !type.equals("") && comparator != '\u0000' && (comparator == '=' || comparator == '!' || comparator == '>' || comparator == '<') && description != null && !description.equals("") && test != null && !test.equals("");
    }

    public void addSubMatcher(MagicMatcher m) {
        this.subMatchers.add(m);
    }

    public Collection<MagicMatcher> getSubMatchers() {
        return this.subMatchers;
    }

    public void setSubMatchers(Collection<MagicMatcher> a) {
        this.subMatchers.clear();
        this.subMatchers.addAll(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MagicMatch test(File f, boolean onlyMimeMatch) throws IOException {
        int offset = this.match.getOffset();
        String description = this.match.getDescription();
        String type = this.match.getType();
        RandomAccessFile file = null;
        file = new RandomAccessFile(f, "r");
        int length = 0;
        if (type.equals("byte")) {
            length = 1;
        } else if (type.equals("short") || type.equals("leshort") || type.equals("beshort")) {
            length = 4;
        } else if (type.equals("long") || type.equals("lelong") || type.equals("belong")) {
            length = 8;
        } else if (type.equals("string")) {
            length = this.match.getTest().capacity();
        } else if (type.equals("regex")) {
            int matchLength = this.match.getLength();
            int n = length = matchLength == 0 ? (int)file.length() - offset : matchLength;
            if (length < 0) {
                length = 0;
            }
        } else if (type.equals("detector") && (length = (int)file.length() - offset) < 0) {
            length = 0;
        }
        if ((long)length > file.length() - (long)offset) {
            MagicMatch matchLength = null;
            return matchLength;
        }
        byte[] buf = new byte[length];
        file.seek(offset);
        int bytesRead = 0;
        int size = 0;
        boolean gotAllBytes = false;
        boolean done = false;
        while (!done) {
            size = file.read(buf, 0, length - bytesRead);
            if (size == -1) {
                throw new IOException("reached end of file before all bytes were read");
            }
            if ((bytesRead += size) != length) continue;
            gotAllBytes = true;
            done = true;
        }
        MagicMatch match = null;
        MagicMatch submatch = null;
        if (this.testInternal(buf)) {
            try {
                match = this.getMatch() != null ? (MagicMatch)this.getMatch().clone() : null;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                // empty catch block
            }
            if (!onlyMimeMatch && this.subMatchers != null && this.subMatchers.size() > 0) {
                for (int i = 0; i < this.subMatchers.size(); ++i) {
                    MagicMatcher m = this.subMatchers.get(i);
                    submatch = m.test(f, false);
                    if (submatch == null) continue;
                    match.addSubMatch(submatch);
                }
            }
        }
        MagicMatch magicMatch = match;
        return magicMatch;
        finally {
            try {
                file.close();
            }
            catch (Exception exception) {}
        }
    }

    public MagicMatch test(byte[] data, boolean onlyMimeMatch) {
        int offset = this.match.getOffset();
        String description = this.match.getDescription();
        String type = this.match.getType();
        String test = new String(this.match.getTest().array());
        String mimeType = this.match.getMimeType();
        int length = 0;
        if (type.equals("byte")) {
            length = 1;
        } else if (type.equals("short") || type.equals("leshort") || type.equals("beshort")) {
            length = 4;
        } else if (type.equals("long") || type.equals("lelong") || type.equals("belong")) {
            length = 8;
        } else if (type.equals("string")) {
            length = this.match.getTest().capacity();
        } else if (type.equals("regex")) {
            length = data.length - offset - 1;
            if (length < 0) {
                length = 0;
            }
        } else if (type.equals("detector")) {
            length = data.length - offset - 1;
            if (length < 0) {
                length = 0;
            }
        } else {
            throw new CommonException("unsupported test type " + type);
        }
        byte[] buf = new byte[length];
        if (offset + length < data.length) {
            System.arraycopy(data, offset, buf, 0, length);
            MagicMatch match = null;
            MagicMatch submatch = null;
            if (this.testInternal(buf)) {
                try {
                    MagicMatch magicMatch = match = this.getMatch() != null ? (MagicMatch)this.getMatch().clone() : null;
                    if (!onlyMimeMatch && this.subMatchers != null && this.subMatchers.size() > 0) {
                        for (int i = 0; i < this.subMatchers.size(); ++i) {
                            MagicMatcher m = this.subMatchers.get(i);
                            submatch = m.test(data, false);
                            if (submatch == null) continue;
                            match.addSubMatch(submatch);
                        }
                    }
                }
                catch (CloneNotSupportedException cloneNotSupportedException) {
                    // empty catch block
                }
            }
            return match;
        }
        return null;
    }

    private boolean testInternal(byte[] data) {
        if (data.length == 0) {
            return false;
        }
        String type = this.match.getType();
        String test = new String(this.match.getTest().array());
        String mimeType = this.match.getMimeType();
        String description = this.match.getDescription();
        ByteBuffer buffer = ByteBuffer.allocate(data.length);
        if (type != null && test != null && test.length() > 0) {
            if (type.equals("string")) {
                buffer = buffer.put(data);
                return this.testString(buffer);
            }
            if (type.equals("byte")) {
                buffer = buffer.put(data);
                return this.testByte(buffer);
            }
            if (type.equals("short")) {
                buffer = buffer.put(data);
                return this.testShort(buffer);
            }
            if (type.equals("leshort")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                return this.testShort(buffer);
            }
            if (type.equals("beshort")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.BIG_ENDIAN);
                return this.testShort(buffer);
            }
            if (type.equals("long")) {
                buffer = buffer.put(data);
                return this.testLong(buffer);
            }
            if (type.equals("lelong")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.LITTLE_ENDIAN);
                return this.testLong(buffer);
            }
            if (type.equals("belong")) {
                buffer = buffer.put(data);
                buffer.order(ByteOrder.BIG_ENDIAN);
                return this.testLong(buffer);
            }
            if (type.equals("regex")) {
                return this.testRegex(new String(data));
            }
            if (type.equals("detector")) {
                buffer = buffer.put(data);
                return this.testDetector(buffer);
            }
        }
        return false;
    }

    private boolean testByte(ByteBuffer data) {
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        long bitmask = this.match.getBitmask();
        String s = test;
        byte b = data.get(0);
        b = (byte)((long)b & bitmask);
        byte tst = Integer.decode(test).byteValue();
        byte t = (byte)(tst & 0xFF);
        switch (comparator) {
            case '=': {
                return t == b;
            }
            case '!': {
                return t != b;
            }
            case '>': {
                return t > b;
            }
            case '<': {
                return t < b;
            }
        }
        return false;
    }

    private boolean testString(ByteBuffer data) {
        ByteBuffer test = this.match.getTest();
        char comparator = this.match.getComparator();
        byte[] b = data.array();
        byte[] t = test.array();
        boolean diff = false;
        int i = 0;
        for (i = 0; i < t.length; ++i) {
            if (t[i] == b[i]) continue;
            diff = true;
            break;
        }
        switch (comparator) {
            case '=': {
                return !diff;
            }
            case '!': {
                return diff;
            }
            case '>': {
                return t[i] > b[i];
            }
            case '<': {
                return t[i] < b[i];
            }
        }
        return false;
    }

    private boolean testShort(ByteBuffer data) {
        short val = 0;
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        long bitmask = this.match.getBitmask();
        val = this.byteArrayToShort(data);
        val = (short)(val & (short)bitmask);
        short tst = 0;
        try {
            tst = Integer.decode(test).shortValue();
        }
        catch (NumberFormatException e) {
            return false;
        }
        switch (comparator) {
            case '=': {
                return val == tst;
            }
            case '!': {
                return val != tst;
            }
            case '>': {
                return val > tst;
            }
            case '<': {
                return val < tst;
            }
        }
        return false;
    }

    private boolean testLong(ByteBuffer data) {
        long val = 0L;
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        long bitmask = this.match.getBitmask();
        val = this.byteArrayToLong(data);
        val &= bitmask;
        long tst = Long.decode(test);
        switch (comparator) {
            case '=': {
                return val == tst;
            }
            case '!': {
                return val != tst;
            }
            case '>': {
                return val > tst;
            }
            case '<': {
                return val < tst;
            }
        }
        return false;
    }

    private boolean testRegex(String text) {
        String test = new String(this.match.getTest().array());
        char comparator = this.match.getComparator();
        if (comparator == '=') {
            return Pattern.matches(test, text);
        }
        if (comparator == '!') {
            return !Pattern.matches(test, text);
        }
        return false;
    }

    private boolean testDetector(ByteBuffer data) {
        String detectorClass = new String(this.match.getTest().array());
        try {
            Class<?> c = Class.forName(detectorClass);
            MagicDetector detector = (MagicDetector)c.newInstance();
            String[] types = detector.process(data.array(), this.match.getOffset(), this.match.getLength(), this.match.getBitmask(), this.match.getComparator(), this.match.getMimeType(), this.match.getProperties());
            if (types != null && types.length > 0) {
                this.match.setMimeType(types[0]);
                return true;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    public String[] getDetectorExtensions() {
        String detectorClass = new String(this.match.getTest().array());
        try {
            Class<?> c = Class.forName(detectorClass);
            MagicDetector detector = (MagicDetector)c.newInstance();
            return detector.getHandledTypes();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return new String[0];
    }

    private String byteToOctalString(byte b) {
        int n1 = b / 32 & 7;
        int n2 = b / 8 & 7;
        int n3 = b & 7;
        return String.valueOf(n1) + String.valueOf(n2) + String.valueOf(n3);
    }

    private short byteArrayToShort(ByteBuffer data) {
        return data.getShort(0);
    }

    private long byteArrayToLong(ByteBuffer data) {
        return data.getInt(0);
    }

    protected MagicMatcher clone() throws CloneNotSupportedException {
        MagicMatcher clone = new MagicMatcher();
        clone.setMatch((MagicMatch)this.match.clone());
        Iterator<MagicMatcher> i = this.subMatchers.iterator();
        ArrayList<MagicMatcher> sub = new ArrayList<MagicMatcher>();
        while (i.hasNext()) {
            MagicMatcher m = i.next();
            sub.add(m.clone());
        }
        clone.setSubMatchers(sub);
        return clone;
    }
}

