/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.aoju.bus.core.lang.exception.CommonException;
import org.aoju.bus.storage.StorageProvider;

public abstract class AbstractProvider
implements StorageProvider {
    protected String prefix;
    protected String bucketName;

    public static String downloadFile(String fileURL, String saveDir) {
        HttpURLConnection httpConn = null;
        FileOutputStream outputStream = null;
        try {
            URL url = new URL(fileURL);
            httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                if (disposition != null) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(index + 10, disposition.length() - 1);
                    }
                } else {
                    fileName = fileURL.substring(fileURL.lastIndexOf("/") + 1, fileURL.length());
                }
                InputStream inputStream = httpConn.getInputStream();
                String saveFilePath = saveDir + File.separator + fileName;
                outputStream = new FileOutputStream(saveFilePath);
                int bytesRead = -1;
                byte[] buffer = new byte[2048];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                String string = saveFilePath;
                return string;
            }
            try {
                throw new CommonException("\u4e0b\u8f7d\u5931\u8d25");
            }
            catch (IOException e) {
                throw new CommonException("\u4e0b\u8f7d\u5931\u8d25", new Object[]{e});
            }
        }
        finally {
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected String getFullPath(String file) {
        if (file.startsWith("http://") || file.startsWith("https://")) {
            return file;
        }
        return this.prefix + file;
    }

    @Override
    public String downloadAndSaveAs(String file, String localSaveDir) {
        return AbstractProvider.downloadFile(this.getUrl(file), localSaveDir);
    }
}

