/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage;

import java.io.File;
import java.io.InputStream;
import java.util.Arrays;
import java.util.UUID;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.storage.magic.MimeType;

public class UploadObject {
    private String fileName;
    private String mimeType;
    private String catalog;
    private String url;
    private byte[] bytes;
    private File file;
    private InputStream inputStream;

    public UploadObject(String filePath) {
        if (filePath.startsWith("http://") || filePath.startsWith("https://")) {
            this.url = filePath;
            this.fileName = UploadObject.parseFileName(this.url);
        } else {
            this.file = new File(filePath);
            this.fileName = this.file.getName();
        }
    }

    public UploadObject(File file) {
        this.fileName = file.getName();
        this.file = file;
    }

    public UploadObject(String fileName, File file) {
        this.fileName = fileName;
        this.file = file;
    }

    public UploadObject(String fileName, InputStream inputStream, String mimeType) {
        this.fileName = fileName;
        this.inputStream = inputStream;
        this.mimeType = mimeType;
    }

    public UploadObject(String fileName, byte[] bytes, String mimeType) {
        this.fileName = fileName;
        this.bytes = bytes;
        this.mimeType = mimeType;
    }

    public static String parseFileName(String filePath) {
        int index = (filePath = filePath.split("\\?")[0]).lastIndexOf("/") + 1;
        if (index > 0) {
            return filePath.substring(index);
        }
        return filePath;
    }

    public String getFileName() {
        String fileExtension;
        if (StringUtils.isBlank((CharSequence)this.fileName)) {
            this.fileName = UUID.randomUUID().toString().replaceAll("\\-", "");
        }
        if (this.mimeType != null && !this.fileName.contains(".") && (fileExtension = MimeType.getFileExtension(this.mimeType)) != null) {
            this.fileName = this.fileName + fileExtension;
        }
        return this.fileName;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getUrl() {
        return this.url;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public File getFile() {
        return this.file;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UploadObject)) {
            return false;
        }
        UploadObject other = (UploadObject)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$mimeType = this.getMimeType();
        String other$mimeType = other.getMimeType();
        if (this$mimeType == null ? other$mimeType != null : !this$mimeType.equals(other$mimeType)) {
            return false;
        }
        String this$catalog = this.getCatalog();
        String other$catalog = other.getCatalog();
        if (this$catalog == null ? other$catalog != null : !this$catalog.equals(other$catalog)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        if (!Arrays.equals(this.getBytes(), other.getBytes())) {
            return false;
        }
        File this$file = this.getFile();
        File other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        InputStream this$inputStream = this.getInputStream();
        InputStream other$inputStream = other.getInputStream();
        return !(this$inputStream == null ? other$inputStream != null : !this$inputStream.equals(other$inputStream));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UploadObject;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $mimeType = this.getMimeType();
        result = result * 59 + ($mimeType == null ? 43 : $mimeType.hashCode());
        String $catalog = this.getCatalog();
        result = result * 59 + ($catalog == null ? 43 : $catalog.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBytes());
        File $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        InputStream $inputStream = this.getInputStream();
        result = result * 59 + ($inputStream == null ? 43 : $inputStream.hashCode());
        return result;
    }

    public String toString() {
        return "UploadObject(fileName=" + this.getFileName() + ", mimeType=" + this.getMimeType() + ", catalog=" + this.getCatalog() + ", url=" + this.getUrl() + ", bytes=" + Arrays.toString(this.getBytes()) + ", file=" + this.getFile() + ", inputStream=" + this.getInputStream() + ")";
    }
}

