/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider.aliyun;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.DateUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.storage.Provider;
import org.aoju.bus.storage.UploadObject;
import org.aoju.bus.storage.UploadToken;
import org.aoju.bus.storage.provider.AbstractProvider;

public class AliyunOSSProvider
extends AbstractProvider {
    private static final String URL_PREFIX_PATTERN = "(http).*\\.(com|cn)\\/";
    private static final String DEFAULT_CALLBACK_BODY = "filename=${object}&size=${size}&mimeType=${mimeType}&height=${imageInfo.height}&width=${imageInfo.width}";
    private OSSClient client;
    private String internalUrl;

    public AliyunOSSProvider(String urlPrefix, String endpoint, String bucket, String accessKey, String secretKey, String internalUrl, boolean privated) {
        Assert.notBlank((String)endpoint, (String)"[endpoint] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)bucket, (String)"[bucketName] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)accessKey, (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)secretKey, (String)"[secretKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)urlPrefix, (String)"[urlprefix] not defined", (Object[])new Object[0]);
        this.internalUrl = internalUrl;
        this.accessKey = accessKey;
        this.client = new OSSClient(endpoint, accessKey, secretKey);
        this.bucket = bucket;
        this.prefix = urlPrefix.endsWith("/") ? urlPrefix : urlPrefix + "/";
        this.privated = privated;
        if (!this.client.doesBucketExist(bucket)) {
            System.out.println("Creating bucket " + bucket + "\n");
            this.client.createBucket(bucket);
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(bucket);
            createBucketRequest.setCannedACL(privated ? CannedAccessControlList.Private : CannedAccessControlList.PublicRead);
            this.client.createBucket(createBucketRequest);
        }
    }

    @Override
    public String upload(UploadObject object) {
        try {
            PutObjectRequest request;
            if (object.getFile() != null) {
                request = new PutObjectRequest(this.bucket, object.getFileName(), object.getFile());
            } else if (object.getBytes() != null) {
                request = new PutObjectRequest(this.bucket, object.getFileName(), (InputStream)new ByteArrayInputStream(object.getBytes()));
            } else if (object.getInputStream() != null) {
                request = new PutObjectRequest(this.bucket, object.getFileName(), object.getInputStream());
            } else {
                throw new IllegalArgumentException("upload object is NULL");
            }
            PutObjectResult result = this.client.putObject(request);
            if (result.getResponse() == null) {
                return this.privated ? object.getFileName() : this.prefix + object.getFileName();
            }
            if (result.getResponse().isSuccessful()) {
                return result.getResponse().getUri();
            }
            throw new InstrumentException(result.getResponse().getErrorResponseAsString());
        }
        catch (OSSException e) {
            throw new InstrumentException(e.getErrorMessage());
        }
    }

    @Override
    public Map<String, Object> createUploadToken(UploadToken param) {
        try {
            HashMap<String, Object> result = new HashMap<String, Object>();
            PolicyConditions policyConds = new PolicyConditions();
            if (param.getFsizeMin() != null && param.getFsizeMax() != null) {
                policyConds.addConditionItem("content-length-range", param.getFsizeMin().longValue(), param.getFsizeMax().longValue());
            } else {
                policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
            }
            if (param.getUploadDir() != null) {
                policyConds.addConditionItem(MatchMode.StartWith, "key", param.getUploadDir());
            }
            if (StringUtils.isBlank((CharSequence)param.getCallbackHost())) {
                param.setCallbackHost(StringUtils.remove((String)this.prefix, (String)"/").split(":")[1]);
            }
            if (StringUtils.isBlank((CharSequence)param.getCallbackBody())) {
                param.setCallbackBody(DEFAULT_CALLBACK_BODY);
            }
            Date expire = DateUtils.addSeconds((Date)new Date(), (int)((int)param.getExpires()));
            String policy = this.client.generatePostPolicy(expire, policyConds);
            String policyBase64 = BinaryUtil.toBase64String((byte[])policy.getBytes(StandardCharsets.UTF_8.name()));
            String callbackBase64 = param.getCallbackRuleAsJson();
            if (StringUtils.isNotEmpty((String)callbackBase64)) {
                callbackBase64 = BinaryUtil.toBase64String((byte[])callbackBase64.getBytes(StandardCharsets.UTF_8.name()));
            }
            result.put("OSSAccessKeyId", this.accessKey);
            result.put("policy", policyBase64);
            result.put("signature", this.client.calculatePostSignature(policy));
            result.put("host", this.prefix);
            result.put("dir", param.getUploadDir());
            result.put("expire", String.valueOf(expire.getTime()));
            if (StringUtils.isNotEmpty((String)callbackBase64)) {
                result.put("callback", callbackBase64);
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean delete(String fileKey) {
        this.client.deleteObject(this.bucket, fileKey);
        return true;
    }

    @Override
    public String getUrl(String fileKey, boolean isInternal) {
        String visitedUrl;
        if (this.privated) {
            URL url = this.client.generatePresignedUrl(this.bucket, fileKey, DateUtils.addHours((Date)new Date(), (int)1));
            visitedUrl = url.toString();
        } else {
            visitedUrl = this.prefix + fileKey;
        }
        if (isInternal) {
            visitedUrl = visitedUrl.replaceFirst(URL_PREFIX_PATTERN, this.internalUrl);
        }
        return visitedUrl;
    }

    @Override
    public void close() {
        this.client.shutdown();
    }

    @Override
    public String name() {
        return Provider.ALI_OSS.getValue();
    }
}

