/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.google.common.collect.Maps;
import com.obs.services.ObsClient;
import com.obs.services.model.DownloadFileRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class HuaweiObsProvider
extends AbstractProvider {
    private ObsClient client;

    public HuaweiObsProvider(Context property) {
        this.property = property;
        Assert.notBlank((String)this.property.getEndpoint(), (String)"[endpoint] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getBucket(), (String)"[bucket] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getAccessKey(), (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getSecretKey(), (String)"[secure] not defined", (Object[])new Object[0]);
        this.client = new ObsClient(this.property.getAccessKey(), this.property.getSecretKey(), this.property.getEndpoint());
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.property.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucket, String fileName) {
        throw new InstrumentException("method not implemented");
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.property.getBucket(), fileName, file);
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        return new Readers(this.client.downloadFile(new DownloadFileRequest(bucket, this.property.getAccessKey(), fileName)));
    }

    @Override
    public Readers list() {
        ListObjectsRequest request = new ListObjectsRequest(this.property.getBucket());
        ObjectListing objectListing = this.client.listObjects(request);
        return new Readers(objectListing.getObjects().stream().map(item -> {
            Attachs storageItem = new Attachs();
            storageItem.setName(item.getObjectKey());
            storageItem.setOwner(item.getOwner().getId());
            storageItem.setType(item.getMetadata().getContentType());
            storageItem.setSize(StringUtils.toString((Object)item.getMetadata().getContentLength()));
            HashMap extended = Maps.newHashMap();
            extended.put("tag", item.getMetadata().getEtag());
            extended.put("storageClass", item.getMetadata().getObjectStorageClass());
            extended.put("lastModified", item.getMetadata().getLastModified());
            storageItem.setExtended(extended);
            return storageItem;
        }).collect(Collectors.toList()));
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.property.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        this.client.putObject(bucket, fileName, content);
        return new Readers("success");
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.property.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        this.client.deleteObject(bucket, fileName);
        return new Readers("success");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

