/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.qiniu.common.QiniuException;
import com.qiniu.http.Response;
import com.qiniu.storage.BucketManager;
import com.qiniu.storage.Configuration;
import com.qiniu.storage.Region;
import com.qiniu.storage.UploadManager;
import com.qiniu.util.Auth;
import java.io.File;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.file.Path;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class QiniuYunOssProvider
extends AbstractProvider {
    private UploadManager uploadManager;
    private BucketManager bucketManager;
    private Auth auth;

    public QiniuYunOssProvider(Context property) {
        this.property = property;
        Assert.notBlank((String)this.property.getPrefix(), (String)"[prefix] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getBucket(), (String)"[bucket] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getAccessKey(), (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getSecretKey(), (String)"[secretKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getRegion(), (String)"[region] not defined", (Object[])new Object[0]);
        Assert.notNull((Object)this.property.isSecure(), (String)"[secure] not defined", (Object[])new Object[0]);
        this.auth = Auth.create((String)this.property.getAccessKey(), (String)this.property.getSecretKey());
        Region region = Region.autoRegion((String)this.property.getRegion());
        Configuration c = new Configuration(region);
        this.uploadManager = new UploadManager(c);
        this.bucketManager = new BucketManager(this.auth, c);
    }

    @Override
    public Readers download(String fileKey) {
        String path = this.getFullPath(fileKey);
        if (this.property.isSecure()) {
            path = this.auth.privateDownloadUrl(path, 3600L);
        }
        try {
            String encodedFileName = URLEncoder.encode(fileKey, "utf-8");
            String format = String.format("%s/%s", path, encodedFileName);
            return new Readers(null, "success");
        }
        catch (UnsupportedEncodingException e) {
            Logger.error((String)"file download failed", (Object[])new Object[]{e.getMessage()});
            return new Readers(null, "failure");
        }
    }

    @Override
    public Readers download(String bucketName, String fileName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers download(String bucketName, String fileName, File file) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers download(String fileName, File file) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers list() {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.property.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        try {
            String upToken = this.auth.uploadToken(bucket);
            Response response = this.uploadManager.put(content, fileName, upToken, null, null);
            if (!response.isOK()) {
                return new Readers(null, response.error);
            }
            return new Readers(Attachs.builder().name(fileName).size(StringUtils.toString((Object)response.body().length)).path(response.url()).build());
        }
        catch (QiniuException e) {
            Logger.error((String)"file upload failed", (Object[])new Object[]{e.getMessage()});
            return new Readers(null, "failure");
        }
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        try {
            String upToken = this.auth.uploadToken(bucket, fileName);
            Response response = this.uploadManager.put(content, fileName, upToken);
            if (!response.isOK()) {
                return new Readers(null, response.error);
            }
            return new Readers(Attachs.builder().size(StringUtils.toString((Object)response.body().length)).name(fileName).path(response.url()).build());
        }
        catch (QiniuException e) {
            Logger.error((String)"file upload failed", (Object[])new Object[]{e.getMessage()});
            return new Readers(null, "failure");
        }
    }

    @Override
    public Readers remove(String fileKey) {
        try {
            if (fileKey.contains("/")) {
                fileKey = fileKey.replace(this.property.getPrefix(), "");
            }
            this.bucketManager.delete(this.property.getBucket(), fileKey);
            return new Readers(null, "success");
        }
        catch (QiniuException e) {
            Logger.error((String)"file remove failed", (Object[])new Object[]{e.getMessage()});
            return new Readers(null, "failure");
        }
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        try {
            this.bucketManager.delete(bucket, fileName);
            return new Readers(null, "success");
        }
        catch (QiniuException e) {
            Logger.error((String)"file remove failed", (Object[])new Object[]{e.getMessage()});
            return new Readers(null, "failure");
        }
    }

    @Override
    public Readers remove(String bucketName, Path path) {
        return this.remove(bucketName, path.toString());
    }
}

