/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectResult;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class AliYunOssProvider
extends AbstractProvider {
    private OSSClient client;

    public AliYunOssProvider(Context property) {
        this.property = property;
        Assert.notBlank((String)this.property.getPrefix(), (String)"[prefix] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getEndpoint(), (String)"[endpoint] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getBucket(), (String)"[bucket] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getAccessKey(), (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getSecretKey(), (String)"[secretKey] not defined", (Object[])new Object[0]);
        Assert.notNull((Object)this.property.isSecure(), (String)"[secure] not defined", (Object[])new Object[0]);
        this.client = new OSSClient(this.property.getEndpoint(), (CredentialsProvider)new DefaultCredentialProvider(this.property.getAccessKey(), this.property.getSecretKey()), null);
        if (!this.client.doesBucketExist(this.property.getBucket())) {
            System.out.println("Creating bucket " + this.property.getBucket() + "\n");
            this.client.createBucket(this.property.getBucket());
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(this.property.getBucket());
            createBucketRequest.setCannedACL(this.property.isSecure() ? CannedAccessControlList.Private : CannedAccessControlList.PublicRead);
            this.client.createBucket(createBucketRequest);
        }
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.property.getBucket(), fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Readers download(String bucketName, String fileName) {
        OSSObject ossObject = this.client.getObject(bucketName, fileName);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ossObject.getObjectContent()));){
            String line;
            while ((line = reader.readLine()) != null) {
            }
            Readers readers = new Readers(reader);
            return readers;
        }
        catch (Exception e) {
            Logger.error((String)"file download failed", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.property.getBucket(), fileName, file);
    }

    @Override
    public Readers download(String bucketName, String fileName, File file) {
        this.client.getObject(new GetObjectRequest(bucketName, fileName), file);
        return new Readers("0");
    }

    @Override
    public Readers list() {
        ListObjectsRequest request = new ListObjectsRequest(this.property.getBucket());
        ObjectListing objectListing = this.client.listObjects(request);
        return new Readers(objectListing.getObjectSummaries().stream().map(item -> {
            Attachs storageItem = new Attachs();
            storageItem.setName(item.getKey());
            storageItem.setSize(StringUtils.toString((Object)item.getSize()));
            HashMap extended = Maps.newHashMap();
            extended.put("tag", item.getETag());
            extended.put("storageClass", item.getStorageClass());
            extended.put("lastModified", item.getLastModified());
            storageItem.setExtended(extended);
            return storageItem;
        }).collect(Collectors.toList()));
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return this.rename(this.property.getBucket(), oldName, newName);
    }

    @Override
    public Readers rename(String bucketName, String oldName, String newName) {
        boolean keyExists = true;
        try {
            this.client.getObjectMetadata(bucketName, oldName);
        }
        catch (Exception e) {
            keyExists = false;
        }
        if (keyExists) {
            this.client.copyObject(bucketName, oldName, bucketName, newName);
        }
        return new Readers("0");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.property.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucketName, String fileName, InputStream content) {
        try {
            byte[] bytes = new byte[content.available()];
            return this.upload(this.property.getBucket(), fileName, bytes);
        }
        catch (IOException e) {
            Logger.error((String)"file upload failed ", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers upload(String bucketName, String fileName, byte[] content) {
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        try {
            PutObjectResult objectResult = this.client.putObject(bucketName, fileName, (InputStream)bis);
            ResponseMessage response = objectResult.getResponse();
            if (!response.isSuccessful()) {
                return new Readers(null, response.getErrorResponseAsString());
            }
            return new Readers(Attachs.builder().name(fileName).size("" + response.getContentLength()).path(response.getUri()).build());
        }
        catch (Exception e) {
            this.client.putObject(bucketName, fileName, (InputStream)bis);
            Logger.error((String)"file upload failed ", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.property.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucketName, String fileName) {
        this.client.deleteObject(bucketName, fileName);
        return new Readers("0");
    }

    @Override
    public Readers remove(String bucketName, Path path) {
        this.remove(bucketName, path.toString());
        return new Readers("0");
    }
}

