/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class JdYunOssProvider
extends AbstractProvider {
    private AmazonS3 client;

    public JdYunOssProvider(Context property) {
        this.property = property;
        Assert.notBlank((String)this.property.getPrefix(), (String)"[prefix] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getEndpoint(), (String)"[endpoint] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getBucket(), (String)"[bucket] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getAccessKey(), (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getSecretKey(), (String)"[secure] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getRegion(), (String)"[region] not defined", (Object[])new Object[0]);
        ClientConfiguration config = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(this.property.getEndpoint(), this.property.getRegion());
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.property.getAccessKey(), this.property.getSecretKey());
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfig)).withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.property.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucket, String fileName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.property.getBucket(), fileName, file);
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        this.client.getObject(new GetObjectRequest(bucket, fileName), file);
        return new Readers("0");
    }

    @Override
    public Readers list() {
        ListObjectsRequest request = new ListObjectsRequest().withBucketName(this.property.getBucket());
        ObjectListing objectListing = this.client.listObjects(request);
        return new Readers(objectListing.getObjectSummaries().stream().map(item -> {
            Attachs storageItem = new Attachs();
            storageItem.setName(item.getKey());
            storageItem.setOwner(item.getOwner().getDisplayName());
            storageItem.setSize(StringUtils.toString((Object)item.getSize()));
            HashMap extended = Maps.newHashMap();
            extended.put("tag", item.getETag());
            extended.put("storageClass", item.getStorageClass());
            extended.put("lastModified", item.getLastModified());
            storageItem.setExtended(extended);
            return storageItem;
        }).collect(Collectors.toList()));
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.property.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        this.client.putObject(bucket, fileName, content, null);
        return new Readers("0");
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        return new Readers("-1");
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.property.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        this.client.deleteObject(bucket, fileName);
        return new Readers("0");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

