/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.google.common.collect.Maps;
import io.minio.MinioClient;
import io.minio.errors.ErrorResponseException;
import io.minio.errors.InsufficientDataException;
import io.minio.errors.InternalException;
import io.minio.errors.InvalidBucketNameException;
import io.minio.errors.InvalidEndpointException;
import io.minio.errors.InvalidPortException;
import io.minio.errors.NoResponseException;
import io.minio.messages.Item;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.file.Path;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.HashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.lang.exception.InstrumentException;
import org.aoju.bus.core.utils.IoUtils;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;
import org.apache.http.entity.ContentType;
import org.xmlpull.v1.XmlPullParserException;

public class MinioOssProvider
extends AbstractProvider {
    private MinioClient client;

    public MinioOssProvider(Context property) {
        this.property = property;
        Assert.notBlank((String)this.property.getPrefix(), (String)"[prefix] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getEndpoint(), (String)"[endpoint] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getBucket(), (String)"[bucket] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getAccessKey(), (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.property.getSecretKey(), (String)"[secretKey] not defined", (Object[])new Object[0]);
        Assert.notNull((Object)this.property.isSecure(), (String)"[secure] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)StringUtils.toString((Object)this.property.getReadTimeout()), (String)"[readTimeout] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)StringUtils.toString((Object)this.property.getConnectTimeout()), (String)"[connectTimeout] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)StringUtils.toString((Object)this.property.getWriteTimeout()), (String)"[writeTimeout] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)StringUtils.toString((Object)this.property.getReadTimeout()), (String)"[readTimeout] not defined", (Object[])new Object[0]);
        try {
            this.client = new MinioClient(this.property.getEndpoint(), this.property.getAccessKey(), this.property.getSecretKey(), this.property.isSecure());
            this.client.setTimeout(Duration.ofSeconds(this.property.getConnectTimeout() != 0L ? this.property.getConnectTimeout() : 10L).toMillis(), Duration.ofSeconds(this.property.getWriteTimeout() != 60L ? this.property.getWriteTimeout() : 60L).toMillis(), Duration.ofSeconds(this.property.getReadTimeout() != 0L ? this.property.getReadTimeout() : 10L).toMillis());
        }
        catch (InvalidEndpointException | InvalidPortException ex) {
            throw new InstrumentException(ex.getMessage());
        }
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.property.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucketName, String fileName) {
        try {
            InputStream inputStream = this.client.getObject(bucketName, fileName);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            return new Readers(bufferedReader);
        }
        catch (Exception e) {
            Logger.error((String)"file download failed", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers download(String bucketName, String fileName, File file) {
        try {
            InputStream inputStream = this.client.getObject(bucketName, fileName);
            FileOutputStream outputStream = new FileOutputStream(file);
            IoUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            Logger.error((String)"file download failed", (Object[])new Object[]{e.getMessage()});
        }
        return new Readers("-1");
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.property.getBucket(), fileName, file);
    }

    @Override
    public Readers list() {
        try {
            Iterable iterable = this.client.listObjects(this.property.getBucket());
            return new Readers(StreamSupport.stream(iterable.spliterator(), true).map(itemResult -> {
                try {
                    Attachs storageItem = new Attachs();
                    Item item = (Item)itemResult.get();
                    storageItem.setName(item.objectName());
                    storageItem.setSize(StringUtils.toString((Object)item.objectSize()));
                    HashMap extended = Maps.newHashMap();
                    extended.put("tag", item.etag());
                    extended.put("storageClass", item.storageClass());
                    extended.put("lastModified", item.lastModified());
                    storageItem.setExtended(extended);
                    return storageItem;
                }
                catch (ErrorResponseException | InsufficientDataException | InternalException | InvalidBucketNameException | NoResponseException | IOException | InvalidKeyException | NoSuchAlgorithmException | XmlPullParserException e) {
                    return new Readers("-1");
                }
            }).collect(Collectors.toList()));
        }
        catch (XmlPullParserException e) {
            Logger.error((String)"file list failed", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers rename(String bucketName, String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        ByteArrayInputStream stream = new ByteArrayInputStream(content);
        return this.upload(this.property.getBucket(), fileName, stream);
    }

    @Override
    public Readers upload(String bucketName, String fileName, InputStream content) {
        try {
            this.client.putObject(bucketName, fileName, content, (long)content.available(), ContentType.APPLICATION_OCTET_STREAM.getMimeType());
            return new Readers(Attachs.builder().name(fileName).path(this.property.getPrefix() + fileName).build());
        }
        catch (Exception e) {
            Logger.error((String)"file upload failed", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers upload(String bucketName, String fileName, byte[] content) {
        return this.upload(bucketName, fileName, new ByteArrayInputStream(content));
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.property.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucketName, String fileName) {
        try {
            this.client.removeObject(bucketName, fileName);
            return new Readers("0");
        }
        catch (Exception e) {
            Logger.error((String)"file remove failed ", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers remove(String bucketName, Path path) {
        return this.remove(bucketName, path.toString());
    }
}

