/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.baidubce.auth.BceCredentials;
import com.baidubce.auth.DefaultBceCredentials;
import com.baidubce.services.bos.BosClient;
import com.baidubce.services.bos.BosClientConfiguration;
import com.baidubce.services.bos.model.GetObjectRequest;
import com.baidubce.services.bos.model.ListObjectsRequest;
import com.baidubce.services.bos.model.ListObjectsResponse;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class BaiduYunBosProvider
extends AbstractProvider {
    private BosClient client;

    public BaiduYunBosProvider(Context context) {
        this.context = context;
        Assert.notBlank((String)this.context.getPrefix(), (String)"[prefix] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getEndpoint(), (String)"[endpoint] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getBucket(), (String)"[bucket] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getAccessKey(), (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getSecretKey(), (String)"[secure] not defined", (Object[])new Object[0]);
        Assert.notNull((Object)this.context.isSecure(), (String)"[secure] not defined", (Object[])new Object[0]);
        BosClientConfiguration config = new BosClientConfiguration();
        config.setCredentials((BceCredentials)new DefaultBceCredentials(this.context.getAccessKey(), this.context.getSecretKey()));
        config.setEndpoint(this.context.getEndpoint());
        this.client = new BosClient(config);
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.context.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucket, String fileName) {
        return new Readers("-1");
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.context.getBucket(), fileName, file);
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        this.client.getObject(new GetObjectRequest(bucket, fileName), file);
        return new Readers("0");
    }

    @Override
    public Readers list() {
        ListObjectsRequest request = new ListObjectsRequest(this.context.getBucket());
        ListObjectsResponse objectListing = this.client.listObjects(request);
        return new Readers(objectListing.getContents().stream().map(item -> {
            Attachs storageItem = new Attachs();
            storageItem.setName(item.getKey());
            storageItem.setOwner(item.getOwner().getDisplayName());
            storageItem.setSize(StringUtils.toString((Object)item.getSize()));
            HashMap extended = Maps.newHashMap();
            extended.put("tag", item.getETag());
            extended.put("storageClass", item.getStorageClass());
            extended.put("lastModified", item.getLastModified());
            storageItem.setExtended(extended);
            return storageItem;
        }).collect(Collectors.toList()));
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.context.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        this.client.putObject(bucket, fileName, content);
        return new Readers("0");
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        this.client.putObject(bucket, fileName, content);
        return new Readers("0");
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.context.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        this.client.deleteObject(bucket, fileName);
        return new Readers("0");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

