/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.common.comm.ResponseMessage;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CreateBucketRequest;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.ListObjectsRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectListing;
import com.aliyun.oss.model.PutObjectResult;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class AliYunOssProvider
extends AbstractProvider {
    private OSSClient client;

    public AliYunOssProvider(Context context) {
        this.context = context;
        Assert.notBlank((String)this.context.getPrefix(), (String)"[prefix] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getEndpoint(), (String)"[endpoint] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getBucket(), (String)"[bucket] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getAccessKey(), (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getSecretKey(), (String)"[secretKey] not defined", (Object[])new Object[0]);
        Assert.notNull((Object)this.context.isSecure(), (String)"[secure] not defined", (Object[])new Object[0]);
        this.client = new OSSClient(this.context.getEndpoint(), (CredentialsProvider)new DefaultCredentialProvider(this.context.getAccessKey(), this.context.getSecretKey()), null);
        if (!this.client.doesBucketExist(this.context.getBucket())) {
            System.out.println("Creating bucket " + this.context.getBucket() + "\n");
            this.client.createBucket(this.context.getBucket());
            CreateBucketRequest createBucketRequest = new CreateBucketRequest(this.context.getBucket());
            createBucketRequest.setCannedACL(this.context.isSecure() ? CannedAccessControlList.Private : CannedAccessControlList.PublicRead);
            this.client.createBucket(createBucketRequest);
        }
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.context.getBucket(), fileName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Readers download(String bucket, String fileName) {
        OSSObject ossObject = this.client.getObject(bucket, fileName);
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(ossObject.getObjectContent()));){
            String line;
            while ((line = reader.readLine()) != null) {
            }
            Readers readers = new Readers(reader);
            return readers;
        }
        catch (Exception e) {
            Logger.error((String)"file download failed", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.context.getBucket(), fileName, file);
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        this.client.getObject(new GetObjectRequest(bucket, fileName), file);
        return new Readers("0");
    }

    @Override
    public Readers list() {
        ListObjectsRequest request = new ListObjectsRequest(this.context.getBucket());
        ObjectListing objectListing = this.client.listObjects(request);
        return new Readers(objectListing.getObjectSummaries().stream().map(item -> {
            Attachs storageItem = new Attachs();
            storageItem.setName(item.getKey());
            storageItem.setSize(StringUtils.toString((Object)item.getSize()));
            HashMap extended = Maps.newHashMap();
            extended.put("tag", item.getETag());
            extended.put("storageClass", item.getStorageClass());
            extended.put("lastModified", item.getLastModified());
            storageItem.setExtended(extended);
            return storageItem;
        }).collect(Collectors.toList()));
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return this.rename(this.context.getBucket(), oldName, newName);
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        boolean keyExists = true;
        try {
            this.client.getObjectMetadata(bucket, oldName);
        }
        catch (Exception e) {
            keyExists = false;
        }
        if (keyExists) {
            this.client.copyObject(bucket, oldName, bucket, newName);
        }
        return new Readers("0");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.context.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        try {
            byte[] bytes = new byte[content.available()];
            return this.upload(this.context.getBucket(), fileName, bytes);
        }
        catch (IOException e) {
            Logger.error((String)"file upload failed ", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        ByteArrayInputStream bis = new ByteArrayInputStream(content);
        try {
            PutObjectResult objectResult = this.client.putObject(bucket, fileName, (InputStream)bis);
            ResponseMessage response = objectResult.getResponse();
            if (!response.isSuccessful()) {
                return new Readers(null, response.getErrorResponseAsString());
            }
            return new Readers(Attachs.builder().name(fileName).size("" + response.getContentLength()).path(response.getUri()).build());
        }
        catch (Exception e) {
            this.client.putObject(bucket, fileName, (InputStream)bis);
            Logger.error((String)"file upload failed ", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.context.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        this.client.deleteObject(bucket, fileName);
        return new Readers("0");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        this.remove(bucket, path.toString());
        return new Readers("0");
    }
}

