/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.UpYun;
import com.upyun.UpException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class UpaiYunOssProvider
extends AbstractProvider {
    private UpYun client;

    public UpaiYunOssProvider(Context context) {
        this.context = context;
        Assert.notBlank((String)this.context.getPrefix(), (String)"[prefix] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getEndpoint(), (String)"[endpoint] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getBucket(), (String)"[bucket] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getAccessKey(), (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((String)this.context.getSecretKey(), (String)"[secure] not defined", (Object[])new Object[0]);
        this.client = new UpYun(this.context.getBucket(), this.context.getAccessKey(), this.context.getSecretKey());
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.context.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucket, String fileName) {
        return new Readers("-1");
    }

    @Override
    public Readers download(String fileName, File file) {
        try {
            this.client.writeFile(fileName, file);
            return new Readers("0");
        }
        catch (UpException | IOException e) {
            Logger.error((String)("file download failed" + e.getMessage()), (Object[])new Object[0]);
            return new Readers("-1");
        }
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        return new Readers("-1");
    }

    @Override
    public Readers list() {
        try {
            List list = this.client.readDir(this.context.getPrefix());
            return new Readers(list.stream().map(item -> {
                Attachs storageItem = new Attachs();
                storageItem.setName(item.name);
                storageItem.setType(item.type);
                storageItem.setSize(StringUtils.toString((Object)item.size));
                return storageItem;
            }).collect(Collectors.toList()));
        }
        catch (UpException | IOException e) {
            Logger.error((String)("file list failed" + e.getMessage()), (Object[])new Object[0]);
            return new Readers("-1");
        }
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.context.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        return new Readers("-1");
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        return new Readers("-1");
    }

    @Override
    public Readers remove(String fileName) {
        try {
            this.client.deleteFile('/' + fileName);
            return new Readers("0");
        }
        catch (UpException | IOException e) {
            Logger.error((String)"file remove failed", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        return new Readers("-1");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

