/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3Client;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.GetObjectRequest;
import com.amazonaws.services.s3.model.ListObjectsRequest;
import com.amazonaws.services.s3.model.ObjectListing;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Attachs;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class JdYunOssProvider
extends AbstractProvider {
    private AmazonS3 client;

    public JdYunOssProvider(Context context) {
        this.context = context;
        Assert.notBlank((CharSequence)this.context.getPrefix(), (String)"[prefix] not defined", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.context.getEndpoint(), (String)"[endpoint] not defined", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.context.getBucket(), (String)"[bucket] not defined", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.context.getAccessKey(), (String)"[accessKey] not defined", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.context.getSecretKey(), (String)"[secure] not defined", (Object[])new Object[0]);
        Assert.notBlank((CharSequence)this.context.getRegion(), (String)"[region] not defined", (Object[])new Object[0]);
        ClientConfiguration config = new ClientConfiguration();
        AwsClientBuilder.EndpointConfiguration endpointConfig = new AwsClientBuilder.EndpointConfiguration(this.context.getEndpoint(), this.context.getRegion());
        BasicAWSCredentials awsCredentials = new BasicAWSCredentials(this.context.getAccessKey(), this.context.getSecretKey());
        AWSStaticCredentialsProvider awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        this.client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3Client.builder().withEndpointConfiguration(endpointConfig)).withClientConfiguration(config)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).disableChunkedEncoding()).withPathStyleAccessEnabled(Boolean.valueOf(true))).build();
    }

    @Override
    public Readers download(String fileName) {
        return this.download(this.context.getBucket(), fileName);
    }

    @Override
    public Readers download(String bucket, String fileName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers download(String fileName, File file) {
        return this.download(this.context.getBucket(), fileName, file);
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        this.client.getObject(new GetObjectRequest(bucket, fileName), file);
        return new Readers("0");
    }

    @Override
    public Readers list() {
        ListObjectsRequest request = new ListObjectsRequest().withBucketName(this.context.getBucket());
        ObjectListing objectListing = this.client.listObjects(request);
        return new Readers(objectListing.getObjectSummaries().stream().map(item -> {
            Attachs storageItem = new Attachs();
            storageItem.setName(item.getKey());
            storageItem.setOwner(item.getOwner().getDisplayName());
            storageItem.setSize(StringUtils.toString((Object)item.getSize()));
            HashMap extend = Maps.newHashMap();
            extend.put("tag", item.getETag());
            extend.put("storageClass", item.getStorageClass());
            extend.put("lastModified", item.getLastModified());
            storageItem.setExtend(extend);
            return storageItem;
        }).collect(Collectors.toList()));
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return new Readers(null, "failure to provide services");
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return new Readers("-1");
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return this.upload(this.context.getBucket(), fileName, content);
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        this.client.putObject(bucket, fileName, content, null);
        return new Readers("0");
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        return new Readers("-1");
    }

    @Override
    public Readers remove(String fileName) {
        return this.remove(this.context.getBucket(), fileName);
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        this.client.deleteObject(bucket, fileName);
        return new Readers("0");
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return this.remove(bucket, path.toString());
    }
}

