/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.aoju.bus.core.lang.Assert;
import org.aoju.bus.core.utils.StreamUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.magic.Readers;
import org.aoju.bus.storage.provider.AbstractProvider;

public class LocalFileProvider
extends AbstractProvider {
    public LocalFileProvider(Context context) {
        this.context = context;
        Assert.notBlank((CharSequence)this.context.getRegion(), (String)"[region] not defined", (Object[])new Object[0]);
    }

    @Override
    public Readers download(String fileName) {
        return new Readers(new File(this.context.getRegion() + "/" + fileName));
    }

    @Override
    public Readers download(String bucket, String fileName) {
        return this.download(this.context.getRegion() + "/" + bucket + "/" + fileName);
    }

    @Override
    public Readers download(String bucket, String fileName, File file) {
        return null;
    }

    @Override
    public Readers download(String fileName, File file) {
        return null;
    }

    @Override
    public Readers list() {
        return null;
    }

    @Override
    public Readers rename(String oldName, String newName) {
        return null;
    }

    @Override
    public Readers rename(String bucket, String oldName, String newName) {
        return null;
    }

    @Override
    public Readers upload(String fileName, byte[] content) {
        return null;
    }

    @Override
    public Readers upload(String bucket, String fileName, InputStream content) {
        try {
            boolean result;
            File dest = new File(this.context.getRegion() + "/" + bucket + "/", fileName);
            if (!new File(dest.getParent()).exists() && !(result = new File(dest.getParent()).mkdirs())) {
                return new Readers("-1");
            }
            OutputStream out = Files.newOutputStream(dest.toPath(), new OpenOption[0]);
            StreamUtils.copy((InputStream)content, (OutputStream)out);
            content.close();
            out.close();
            return new Readers("0");
        }
        catch (IOException e) {
            Logger.error((String)"file upload failed", (Object[])new Object[]{e.getMessage()});
            return new Readers("-1");
        }
    }

    @Override
    public Readers upload(String bucket, String fileName, byte[] content) {
        return null;
    }

    @Override
    public Readers remove(String fileName) {
        return null;
    }

    @Override
    public Readers remove(String bucket, String fileName) {
        return null;
    }

    @Override
    public Readers remove(String bucket, Path path) {
        return null;
    }
}

