/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.storage.provider;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import org.aoju.bus.core.exception.InternalException;
import org.aoju.bus.storage.Context;
import org.aoju.bus.storage.Provider;

public abstract class AbstractProvider
implements Provider {
    protected Context context;

    protected static String downloadFile(String fileURL, String saveDir) {
        HttpURLConnection httpConn = null;
        FileOutputStream outputStream = null;
        try {
            URL url = new URL(fileURL);
            httpConn = (HttpURLConnection)url.openConnection();
            int responseCode = httpConn.getResponseCode();
            if (responseCode == 200) {
                String fileName = "";
                String disposition = httpConn.getHeaderField("Content-Disposition");
                if (null != disposition) {
                    int index = disposition.indexOf("filename=");
                    if (index > 0) {
                        fileName = disposition.substring(index + 10, disposition.length() - 1);
                    }
                } else {
                    fileName = fileURL.substring(fileURL.lastIndexOf(47) + 1);
                }
                InputStream inputStream = httpConn.getInputStream();
                String saveFilePath = saveDir + File.separator + fileName;
                outputStream = new FileOutputStream(saveFilePath);
                int bytesRead = -1;
                byte[] buffer = new byte[2048];
                while ((bytesRead = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                outputStream.close();
                inputStream.close();
                String string = saveFilePath;
                return string;
            }
            try {
                throw new InternalException("file download failed");
            }
            catch (IOException e) {
                throw new InternalException("file download failed", (Throwable)e);
            }
        }
        finally {
            try {
                if (null != outputStream) {
                    outputStream.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (null != httpConn) {
                    httpConn.disconnect();
                }
            }
            catch (Exception exception) {}
        }
    }

    protected String getFullPath(String file) {
        if (file.startsWith("http://") || file.startsWith("https://")) {
            return file;
        }
        return this.context.getPrefix() + file;
    }
}

