/*! JsRender v1.0.0: http://jsviews.com/#jsrender */
/*! **VERSION FOR WEB** (For NODE.JS see http://jsviews.com/download/jsrender-node.js) */
/*
 * Best-of-breed templating in browser or on Node.js.
 * Does not require jQuery, or HTML DOM
 * Integrates with JsViews (http://jsviews.com/#jsviews)
 *
 * Copyright 2018, Boris Moore
 * Released under the MIT License.
 */

//jshint -W018, -W041, -W120

(function (factory, global) {
    // global var is the this object, which is window when running in the usual browser environment
    var $ = global.jQuery;

    if (typeof exports === "object") { // CommonJS e.g. Browserify
        module.exports = $
            ? factory(global, $)
            : function ($) { // If no global jQuery, take optional jQuery passed as parameter: require('jsrender')(jQuery)
                if ($ && !$.fn) {
                    throw "Provide jQuery or null";
                }
                return factory(global, $);
            };
    } else if (typeof define === "function" && define.amd) { // AMD script loader, e.g. RequireJS
        define(function () {
            return factory(global);
        });
    } else { // Browser using plain <script> tag
        factory(global, false);
    }
}(
// factory (for jsrender.js)
    function (global, $) {
        "use strict";

//========================== Top-level vars ==========================

// global var is the this object, which is window when running in the usual browser environment
        var setGlobals = $ === false; // Only set globals if script block in browser (not AMD and not CommonJS)

        $ = $ && $.fn ? $ : global.jQuery; // $ is jQuery passed in by CommonJS loader (Browserify), or global jQuery.

        var versionNumber = "v1.0.0",
            jsvStoreName, rTag, rTmplString, topView, $views, $expando,
            _ocp = "_ocp", // Observable contextual parameter

//TODO	tmplFnsCache = {},
            $isFunction, $isArray, $templates, $converters, $helpers, $tags, $sub, $subSettings, $subSettingsAdvanced,
            $viewsSettings, delimOpenChar0, delimOpenChar1, delimCloseChar0, delimCloseChar1, linkChar, setting,
            baseOnError,

            rPath = /^(!*?)(?:null|true|false|\d[\d.]*|([\w$]+|\.|~([\w$]+)|#(view|([\w$]+))?)([\w$.^]*?)(?:[.[^]([\w$]+)\]?)?)$/g,
            //        not                               object     helper    view  viewProperty pathTokens      leafToken

            rParams = /(\()(?=\s*\()|(?:([([])\s*)?(?:(\^?)(~?[\w$.^]+)?\s*((\+\+|--)|\+|-|~(?![\w$_])|&&|\|\||===|!==|==|!=|<=|>=|[<>%*:?\/]|(=))\s*|(!*?(@)?[#~]?[\w$.^]+)([([])?)|(,\s*)|(\(?)\\?(?:(')|("))|(?:\s*(([)\]])(?=[.^]|\s*$|[^([])|[)\]])([([]?))|(\s+)/g,
            //         lftPrn0          lftPrn        bound path             operator err                                         eq      path2 late            prn      comma  lftPrn2   apos quot        rtPrn  rtPrnDot                  prn2     space
            // (left paren? followed by (path? followed by operator) or (path followed by left paren?)) or comma or apos or quot or right paren or space

            isRenderCall,
            rNewLine = /[ \t]*(\r\n|\n|\r)/g,
            rUnescapeQuotes = /\\(['"])/g,
            rEscapeQuotes = /['"\\]/g, // Escape quotes and \ character
            rBuildHash = /(?:\x08|^)(onerror:)?(?:(~?)(([\w$_\.]+):)?([^\x08]+))\x08(,)?([^\x08]+)/gi,
            rTestElseIf = /^if\s/,
            rFirstElem = /<(\w+)[>\s]/,
            rAttrEncode = /[\x00`><"'&=]/g, // Includes > encoding since rConvertMarkers in JsViews does not skip > characters in attribute strings
            rIsHtml = /[\x00`><\"'&=]/,
            rHasHandlers = /^on[A-Z]|^convert(Back)?$/,
            rWrappedInViewMarker = /^\#\d+_`[\s\S]*\/\d+_`$/,
            rHtmlEncode = rAttrEncode,
            rDataEncode = /[&<>]/g,
            rDataUnencode = /&(amp|gt|lt);/g,
            rBracketQuote = /\[['"]?|['"]?\]/g,
            viewId = 0,
            charEntities = {
                "&": "&amp;",
                "<": "&lt;",
                ">": "&gt;",
                "\x00": "&#0;",
                "'": "&#39;",
                '"': "&#34;",
                "`": "&#96;",
                "=": "&#61;"
            },
            charsFromEntities = {
                amp: "&",
                gt: ">",
                lt: "<"
            },
            HTML = "html",
            OBJECT = "object",
            tmplAttr = "data-jsv-tmpl",
            jsvTmpl = "jsvTmpl",
            indexStr = "For #index in nested block use #getIndex().",
            $render = {},

            jsr = global.jsrender,
            jsrToJq = jsr && $ && !$.render, // JsRender already loaded, without jQuery. but we will re-load it now to attach to jQuery

            jsvStores = {
                template: {
                    compile: compileTmpl
                },
                tag: {
                    compile: compileTag
                },
                viewModel: {
                    compile: compileViewModel
                },
                helper: {},
                converter: {}
            };

        // views object ($.views if jQuery is loaded, jsrender.views if no jQuery, e.g. in Node.js)
        $views = {
            jsviews: versionNumber,
            sub: {
                // subscription, e.g. JsViews integration
                View: View,
                Err: JsViewsError,
                tmplFn: tmplFn,
                parse: parseParams,
                extend: $extend,
                extendCtx: extendCtx,
                syntaxErr: syntaxError,
                onStore: {
                    template: function (name, item) {
                        if (item === null) {
                            delete $render[name];
                        } else if (name) {
                            $render[name] = item;
                        }
                    }
                },
                addSetting: addSetting,
                settings: {
                    allowCode: false
                },
                advSet: noop, // Update advanced settings
                _thp: tagHandlersFromProps,
                _gm: getMethod,
                _tg: function () {
                }, // Constructor for tagDef
                _cnvt: convertVal,
                _tag: renderTag,
                _er: error,
                _err: onRenderError,
                _cp: retVal, // Get observable contextual parameters (or properties) ~foo=expr. In JsRender, simply returns val.
                _sq: function (token) {
                    if (token === "constructor") {
                        syntaxError("");
                    }
                    return token;
                }
            },
            settings: {
                delimiters: $viewsDelimiters,
                advanced: function (value) {
                    return value
                        ? (
                            $extend($subSettingsAdvanced, value),
                                $sub.advSet(),
                                $viewsSettings
                        )
                        : $subSettingsAdvanced;
                }
            },
            map: dataMap    // If jsObservable loaded first, use that definition of dataMap
        };

        function getDerivedMethod(baseMethod, method) {
            return function () {
                var ret,
                    tag = this,
                    prevBase = tag.base;

                tag.base = baseMethod; // Within method call, calling this.base will call the base method
                ret = method.apply(tag, arguments); // Call the method
                tag.base = prevBase; // Replace this.base to be the base method of the previous call, for chained calls
                return ret;
            };
        }

        function getMethod(baseMethod, method) {
            // For derived methods (or handlers declared declaratively as in {{:foo onChange=~fooChanged}} replace by a derived method, to allow using this.base(...)
            // or this.baseApply(arguments) to call the base implementation. (Equivalent to this._super(...) and this._superApply(arguments) in jQuery UI)
            if ($isFunction(method)) {
                method = getDerivedMethod(
                    !baseMethod
                        ? noop // no base method implementation, so use noop as base method
                        : baseMethod._d
                        ? baseMethod // baseMethod is a derived method, so use it
                        : getDerivedMethod(noop, baseMethod), // baseMethod is not derived so make its base method be the noop method
                    method
                );
                method._d = (baseMethod && baseMethod._d || 0) + 1; // Add flag for derived method (incremented for derived of derived...)
            }
            return method;
        }

        function tagHandlersFromProps(tag, tagCtx) {
            var prop,
                props = tagCtx.props;
            for (prop in props) {
                if (rHasHandlers.test(prop) && !(tag[prop] && tag[prop].fix)) { // Don't override handlers with fix expando (used in datepicker and spinner)
                    tag[prop] = prop !== "convert" ? getMethod(tag.constructor.prototype[prop], props[prop]) : props[prop];
                    // Copy over the onFoo props, convert and convertBack from tagCtx.props to tag (overrides values in tagDef).
                    // Note: unsupported scenario: if handlers are dynamically added ^onFoo=expression this will work, but dynamically removing will not work.
                }
            }
        }

        function retVal(val) {
            return val;
        }

        function noop() {
            return "";
        }

        function dbgBreak(val) {
            // Usage examples: {{dbg:...}}, {{:~dbg(...)}}, {{dbg .../}}, {^{for ... onAfterLink=~dbg}} etc.
            try {
                console.log("JsRender dbg breakpoint: " + val);
                throw "dbg breakpoint"; // To break here, stop on caught exceptions.
            } catch (e) {
            }
            return this.base ? this.baseApply(arguments) : val;
        }

        function JsViewsError(message) {
            // Error exception type for JsViews/JsRender
            // Override of $.views.sub.Error is possible
            this.name = ($.link ? "JsViews" : "JsRender") + " Error";
            this.message = message || this.name;
        }

        function $extend(target, source) {
            if (target) {
                for (var name in source) {
                    target[name] = source[name];
                }
                return target;
            }
        }

        (JsViewsError.prototype = new Error()).constructor = JsViewsError;

//========================== Top-level functions ==========================

//===================
// views.delimiters
//===================

        /**
         * Set the tag opening and closing delimiters and 'link' character. Default is "{{", "}}" and "^"
         * openChars, closeChars: opening and closing strings, each with two characters
         * $.views.settings.delimiters(...)
         *
         * @param {string}   openChars
         * @param {string}   [closeChars]
         * @param {string}   [link]
         * @returns {Settings}
         *
         * Get delimiters
         * delimsArray = $.views.settings.delimiters()
         *
         * @returns {string[]}
         */
        function $viewsDelimiters(openChars, closeChars, link) {
            if (!openChars) {
                return $subSettings.delimiters;
            }
            if ($isArray(openChars)) {
                return $viewsDelimiters.apply($views, openChars);
            }
            linkChar = link ? link[0] : linkChar;
            if (!/^(\W|_){5}$/.test(openChars + closeChars + linkChar)) {
                error("Invalid delimiters"); // Must be non-word characters, and openChars and closeChars must each be length 2
            }
            delimOpenChar0 = openChars[0];
            delimOpenChar1 = openChars[1];
            delimCloseChar0 = closeChars[0];
            delimCloseChar1 = closeChars[1];

            $subSettings.delimiters = [delimOpenChar0 + delimOpenChar1, delimCloseChar0 + delimCloseChar1, linkChar];

            // Escape the characters - since they could be regex special characters
            openChars = "\\" + delimOpenChar0 + "(\\" + linkChar + ")?\\" + delimOpenChar1; // Default is "{^{"
            closeChars = "\\" + delimCloseChar0 + "\\" + delimCloseChar1;                   // Default is "}}"
            // Build regex with new delimiters
            //          [tag    (followed by / space or })  or cvtr+colon or html or code] followed by space+params then convertBack?
            rTag = "(?:(\\w+(?=[\\/\\s\\" + delimCloseChar0 + "]))|(\\w+)?(:)|(>)|(\\*))\\s*((?:[^\\"
                + delimCloseChar0 + "]|\\" + delimCloseChar0 + "(?!\\" + delimCloseChar1 + "))*?)";

            // Make rTag available to JsViews (or other components) for parsing binding expressions
            $sub.rTag = "(?:" + rTag + ")";
            //                        { ^? {   tag+params slash?  or closingTag                                                   or comment
            rTag = new RegExp("(?:" + openChars + rTag + "(\\/)?|\\" + delimOpenChar0 + "(\\" + linkChar + ")?\\" + delimOpenChar1 + "(?:(?:\\/(\\w+))\\s*|!--[\\s\\S]*?--))" + closeChars, "g");

            // Default:  bind     tagName         cvt   cln html code    params            slash   bind2         closeBlk  comment
            //      /(?:{(\^)?{(?:(\w+(?=[\/\s}]))|(\w+)?(:)|(>)|(\*))\s*((?:[^}]|}(?!}))*?)(\/)?|{(\^)?{(?:(?:\/(\w+))\s*|!--[\s\S]*?--))}}

            $sub.rTmpl = new RegExp("^\\s|\\s$|<.*>|([^\\\\]|^)[{}]|" + openChars + ".*" + closeChars);
            // $sub.rTmpl looks for initial or final white space, html tags or { or } char not preceded by \\, or JsRender tags {{xxx}}.
            // Each of these strings are considered NOT to be jQuery selectors
            return $viewsSettings;
        }

//=========
// View.get
//=========

        function getView(inner, type) { //view.get(inner, type)
            if (!type && inner !== true) {
                // view.get(type)
                type = inner;
                inner = undefined;
            }

            var views, i, l, found,
                view = this,
                root = type === "root";
            // view.get("root") returns view.root, view.get() returns view.parent, view.get(true) returns view.views[0].

            if (inner) {
                // Go through views - this first, and all nested ones, depth-first - and return first first with given type.
                // If type is undefined, i.e. view.get(true), return first child view.
                found = type && view.type === type && view;
                if (!found) {
                    views = view.views;
                    if (view._.useKey) {
                        for (i in views) {
                            if (found = type ? views[i].get(inner, type) : views[i]) {
                                break;
                            }
                        }
                    } else {
                        for (i = 0, l = views.length; !found && i < l; i++) {
                            found = type ? views[i].get(inner, type) : views[i];
                        }
                    }
                }
            } else if (root) {
                // Find root view. (view whose parent is top view)
                found = view.root;
            } else if (type) {
                while (view && !found) {
                    // Go through views - this first, and all parent ones - and return first first with given type.
                    found = view.type === type ? view : undefined;
                    view = view.parent;
                }
            } else {
                found = view.parent;
            }
            return found || undefined;
        }

        function getNestedIndex() {
            var view = this.get("item");
            return view ? view.index : undefined;
        }

        getNestedIndex.depends = function () {
            return [this.get("item"), "index"];
        };

        function getIndex() {
            return this.index;
        }

        getIndex.depends = "index";

//==================
// View.ctxPrm, etc.
//==================

        /* Internal private: view._getOb() */
        function getPathObject(ob, path, ltOb, fn) {
            // Iterate through path to late paths: @a.b.c paths
            // Return "" (or noop if leaf is a function @a.b.c(...) ) if intermediate object not yet available
            var prevOb, tokens, l,
                i = 0;
            if (ltOb === 1) {
                fn = 1;
                ltOb = undefined;
            }
            // Paths like ^a^b^c or ~^a^b^c will not throw if an object in path is undefined.
            if (path) {
                tokens = path.split(".");
                l = tokens.length;

                for (; ob && i < l; i++) {
                    prevOb = ob;
                    ob = tokens[i] ? ob[tokens[i]] : ob;
                }
            }
            if (ltOb) {
                ltOb.lt = ltOb.lt || i < l; // If i < l there was an object in the path not yet available
            }
            return ob === undefined
                ? fn ? noop : ""
                : fn ? function () {
                    return ob.apply(prevOb, arguments);
                } : ob;
        }

        function contextParameter(key, value, get) {
            // Helper method called as view.ctxPrm(key) for helpers or template parameters ~foo - from compiled template or from context callback
            var wrapped, deps, res, obsCtxPrm, tagElse, callView, newRes,
                storeView = this,
                isUpdate = !isRenderCall && arguments.length > 1,
                store = storeView.ctx;
            if (key) {
                if (!storeView._) { // tagCtx.ctxPrm() call
                    tagElse = storeView.index;
                    storeView = storeView.tag;
                }
                callView = storeView;
                if (store && store.hasOwnProperty(key) || (store = $helpers).hasOwnProperty(key)) {
                    res = store[key];
                    if (key === "tag" || key === "tagCtx" || key === "root" || key === "parentTags" || storeView._.it === key) {
                        return res;
                    }
                } else {
                    store = undefined;
                }
                if (!isRenderCall && storeView.tagCtx || storeView.linked) { // Data-linked view, or tag instance
                    if (!res || !res._cxp) {
                        // Not a contextual parameter
                        // Set storeView to tag (if this is a tag.ctxPrm() call) or to root view ("data" view of linked template)
                        storeView = storeView.tagCtx || $isFunction(res)
                            ? storeView // Is a tag, not a view, or is a computed contextual parameter, so scope to the callView, no the 'scope view'
                            : (storeView = storeView.scope || storeView,
                            !storeView.isTop && storeView.ctx.tag // If this view is in a tag, set storeView to the tag
                            || storeView);
                        if (res !== undefined && storeView.tagCtx) {
                            // If storeView is a tag, but the contextual parameter has been set at at higher level (e.g. helpers)...
                            storeView = storeView.tagCtx.view.scope; //  then move storeView to the outer level (scope of tag container view)
                        }
                        store = storeView._ocps;
                        res = store && store.hasOwnProperty(key) && store[key] || res;
                        if (!(res && res._cxp) && (get || isUpdate)) {
                            // Create observable contextual parameter
                            (store || (storeView._ocps = storeView._ocps || {}))[key]
                                = res
                                = [{
                                _ocp: res, // The observable contextual parameter value
                                _vw: callView,
                                _key: key
                            }];
                            res._cxp = {
                                path: _ocp,
                                ind: 0,
                                updateValue: function (val, path) {
                                    $.observable(res[0]).setProperty(_ocp, val); // Set the value (res[0]._ocp)
                                    return this;
                                }
                            };
                        }
                    }
                    if (obsCtxPrm = res && res._cxp) {
                        // If this helper resource is an observable contextual parameter
                        if (arguments.length > 2) {
                            deps = res[1] ? $sub._ceo(res[1].deps) : [_ocp]; // fn deps (with any exprObs cloned using $sub._ceo)
                            deps.unshift(res[0]); // view
                            deps._cxp = obsCtxPrm;
                            // In a context callback for a contextual param, we set get = true, to get ctxPrm  [view, dependencies...] array - needed for observe call
                            return deps;
                        }
                        tagElse = obsCtxPrm.tagElse;
                        newRes = res[1] // linkFn for compiled expression
                            ? obsCtxPrm.tag && obsCtxPrm.tag.cvtArgs
                                ? obsCtxPrm.tag.cvtArgs(tagElse, 1)[obsCtxPrm.ind] // = tag.bndArgs() - for tag contextual parameter
                                : res[1](res[0].data, res[0], $sub)    // = fn(data, view, $sub) for compiled binding expression
                            : res[0]._ocp; // Observable contextual parameter (uninitialized, or initialized as static expression, so no path dependencies)
                        if (isUpdate) {
                            if (res && newRes !== value) {
                                $sub._ucp(key, value, storeView, obsCtxPrm); // Update observable contextual parameter
                            }
                            return storeView;
                        }
                        res = newRes;
                    }
                }
                if (res && $isFunction(res)) {
                    // If a helper is of type function we will wrap it, so if called with no this pointer it will be called with the
                    // view as 'this' context. If the helper ~foo() was in a data-link expression, the view will have a 'temporary' linkCtx property too.
                    // Note that helper functions on deeper paths will have specific this pointers, from the preceding path.
                    // For example, ~util.foo() will have the ~util object as 'this' pointer
                    wrapped = function () {
                        return res.apply((!this || this === global) ? callView : this, arguments);
                    };
                    $extend(wrapped, res); // Attach same expandos (if any) to the wrapped function
                    wrapped._vw = callView;
                }
                return wrapped || res;
            }
        }

        /* Internal private: view._getTmpl() */
        function getTemplate(tmpl) {
            return tmpl && (tmpl.fn
                ? tmpl
                : this.getRsc("templates", tmpl) || $templates(tmpl)); // not yet compiled
        }

//==============
// views._cnvt
//==============

        function convertVal(converter, view, tagCtx, onError) {
            // Called from compiled template code for {{:}}
            // self is template object or linkCtx object
            var tag, value, argsLen, bindTo,
                // If tagCtx is an integer, then it is the key for the compiled function to return the boundTag tagCtx
                boundTag = typeof tagCtx === "number" && view.tmpl.bnds[tagCtx - 1],
                linkCtx = view._lc; // For data-link="{cvt:...}"...

            if (onError === undefined && boundTag && boundTag._lr) { // lateRender
                onError = "";
            }
            if (onError !== undefined) {
                tagCtx = onError = {props: {}, args: [onError]};
            } else if (boundTag) {
                tagCtx = boundTag(view.data, view, $sub);
            }
            boundTag = boundTag._bd && boundTag;
            if (converter || boundTag) {
                tag = linkCtx && linkCtx.tag;
                tagCtx.view = view;
                if (!tag) {
                    tag = $extend(new $sub._tg(), {
                        _: {
                            bnd: boundTag,
                            unlinked: true,
                            lt: tagCtx.lt // If a late path @some.path has not returned @some object, mark tag as late
                        },
                        inline: !linkCtx,
                        tagName: ":",
                        convert: converter,
                        flow: true,
                        tagCtx: tagCtx,
                        tagCtxs: [tagCtx],
                        _is: "tag"
                    });
                    argsLen = tagCtx.args.length;
                    if (argsLen > 1) {
                        bindTo = tag.bindTo = [];
                        while (argsLen--) {
                            bindTo.unshift(argsLen); // Bind to all the arguments - generate bindTo array: [0,1,2...]
                        }
                    }
                    if (linkCtx) {
                        linkCtx.tag = tag;
                        tag.linkCtx = linkCtx;
                    }
                    tagCtx.ctx = extendCtx(tagCtx.ctx, (linkCtx ? linkCtx.view : view).ctx);
                    tagHandlersFromProps(tag, tagCtx);
                }
                tag._er = onError && value;
                tag.ctx = tagCtx.ctx || tag.ctx || {};
                tagCtx.ctx = undefined;
                value = tag.cvtArgs()[0]; // If there is a convertBack but no convert, converter will be "true"
                tag._er = onError && value;
            } else {
                value = tagCtx.args[0];
            }

            // Call onRender (used by JsViews if present, to add binding annotations around rendered content)
            value = boundTag && view._.onRender
                ? view._.onRender(value, view, tag)
                : value;
            return value != undefined ? value : "";
        }

        function convertArgs(tagElse, bound) { // tag.cvtArgs() or tag.cvtArgs(tagElse?, true?)
            var l, key, boundArgs, args, bindFrom, tag, converter,
                tagCtx = this;

            if (tagCtx.tagName) {
                tag = tagCtx;
                tagCtx = (tag.tagCtxs || [tagCtx])[tagElse || 0];
                if (!tagCtx) {
                    return;
                }
            } else {
                tag = tagCtx.tag;
            }

            bindFrom = tag.bindFrom;
            args = tagCtx.args;

            if ((converter = tag.convert) && "" + converter === converter) {
                converter = converter === "true"
                    ? undefined
                    : (tagCtx.view.getRsc("converters", converter) || error("Unknown converter: '" + converter + "'"));
            }

            if (converter && !bound) { // If there is a converter, use a copy of the tagCtx.args array for rendering, and replace the args[0] in
                args = args.slice(); // the copied array with the converted value. But we do not modify the value of tag.tagCtx.args[0] (the original args array)
            }
            if (bindFrom) { // Get the values of the boundArgs
                boundArgs = [];
                l = bindFrom.length;
                while (l--) {
                    key = bindFrom[l];
                    boundArgs.unshift(argOrProp(tagCtx, key));
                }
                if (bound) {
                    args = boundArgs; // Call to bndArgs() - returns the boundArgs
                }
            }
            if (converter) {
                converter = converter.apply(tag, boundArgs || args);
                if (converter === undefined) {
                    return args; // Returning undefined from a converter is equivalent to not having a converter.
                }
                bindFrom = bindFrom || [0];
                l = bindFrom.length;
                if (!$isArray(converter) || converter.length !== l) {
                    converter = [converter];
                    bindFrom = [0];
                    l = 1;
                }
                if (bound) {        // Call to bndArgs() - so apply converter to all boundArgs
                    args = converter; // The array of values returned from the converter
                } else {            // Call to cvtArgs()
                    while (l--) {
                        key = bindFrom[l];
                        if (+key === key) {
                            args[key] = converter[l];
                        }
                    }
                }
            }
            return args;
        }

        function argOrProp(context, key) {
            context = context[+key === key ? "args" : "props"];
            return context && context[key];
        }

        function convertBoundArgs(tagElse) { // tag.bndArgs()
            return this.cvtArgs(tagElse, 1);
        }

//=============
// views.tag
//=============

        /* view.getRsc() */
        function getResource(resourceType, itemName) {
            var res, store,
                view = this;
            if ("" + itemName === itemName) {
                while ((res === undefined) && view) {
                    store = view.tmpl && view.tmpl[resourceType];
                    res = store && store[itemName];
                    view = view.parent;
                }
                return res || $views[resourceType][itemName];
            }
        }

        function renderTag(tagName, parentView, tmpl, tagCtxs, isUpdate, onError) {
            function bindToOrBindFrom(type) {
                var bindArray = tag[type];

                if (bindArray !== undefined) {
                    bindArray = $isArray(bindArray) ? bindArray : [bindArray];
                    m = bindArray.length;
                    while (m--) {
                        key = bindArray[m];
                        if (!isNaN(parseInt(key))) {
                            bindArray[m] = parseInt(key); // Convert "0" to 0,  etc.
                        }
                    }
                }

                return bindArray || [0];
            }

            parentView = parentView || topView;
            var tag, tagDef, template, tags, attr, parentTag, l, m, n, itemRet, tagCtx, tagCtxCtx, ctxPrm, bindTo,
                bindFrom, initVal,
                content, callInit, mapDef, thisMap, args, bdArgs, props, tagDataMap, contentCtx, key, bindFromLength,
                bindToLength, linkedElement, defaultCtx,
                i = 0,
                ret = "",
                linkCtx = parentView._lc || false,
                ctx = parentView.ctx,
                parentTmpl = tmpl || parentView.tmpl,
                // If tagCtxs is an integer, then it is the key for the compiled function to return the boundTag tagCtxs
                boundTag = typeof tagCtxs === "number" && parentView.tmpl.bnds[tagCtxs - 1];

            if (tagName._is === "tag") {
                tag = tagName;
                tagName = tag.tagName;
                tagCtxs = tag.tagCtxs;
                template = tag.template;
            } else {
                tagDef = parentView.getRsc("tags", tagName) || error("Unknown tag: {{" + tagName + "}} ");
                template = tagDef.template;
            }
            if (onError === undefined && boundTag && (boundTag._lr = (tagDef.lateRender && boundTag._lr !== false || boundTag._lr))) {
                onError = ""; // If lateRender, set temporary onError, to skip initial rendering (and render just "")
            }
            if (onError !== undefined) {
                ret += onError;
                tagCtxs = onError = [{props: {}, args: [], params: {props: {}}}];
            } else if (boundTag) {
                tagCtxs = boundTag(parentView.data, parentView, $sub);
            }

            l = tagCtxs.length;
            for (; i < l; i++) {
                tagCtx = tagCtxs[i];
                content = tagCtx.tmpl;
                if (!linkCtx || !linkCtx.tag || i && !linkCtx.tag.inline || tag._er || content && +content === content) {
                    // Initialize tagCtx
                    // For block tags, tagCtx.tmpl is an integer > 0
                    if (content && parentTmpl.tmpls) {
                        tagCtx.tmpl = tagCtx.content = parentTmpl.tmpls[content - 1]; // Set the tmpl property to the content of the block tag
                    }
                    tagCtx.index = i;
                    tagCtx.ctxPrm = contextParameter;
                    tagCtx.render = renderContent;
                    tagCtx.cvtArgs = convertArgs;
                    tagCtx.bndArgs = convertBoundArgs;
                    tagCtx.view = parentView;
                    tagCtx.ctx = extendCtx(extendCtx(tagCtx.ctx, tagDef && tagDef.ctx), ctx); // Clone and extend parentView.ctx
                }
                if (tmpl = tagCtx.props.tmpl) {
                    // If the tmpl property is overridden, set the value (when initializing, or, in case of binding: ^tmpl=..., when updating)
                    tagCtx.tmpl = parentView._getTmpl(tmpl);
                    tagCtx.content = tagCtx.content || tagCtx.tmpl;
                }

                if (!tag) {
                    // This will only be hit for initial tagCtx (not for {{else}}) - if the tag instance does not exist yet
                    // If the tag has not already been instantiated, we will create a new instance.
                    // ~tag will access the tag, even within the rendering of the template content of this tag.
                    // From child/descendant tags, can access using ~tag.parent, or ~parentTags.tagName
                    tag = new tagDef._ctr();
                    callInit = !!tag.init;

                    tag.parent = parentTag = ctx && ctx.tag;
                    tag.tagCtxs = tagCtxs;

                    if (linkCtx) {
                        tag.inline = false;
                        linkCtx.tag = tag;
                    }
                    tag.linkCtx = linkCtx;
                    if (tag._.bnd = boundTag || linkCtx.fn) {
                        // Bound if {^{tag...}} or data-link="{tag...}"
                        tag._.ths = tagCtx.params.props.this; // Tag has a this=expr binding, to get javascript reference to tag instance
                        tag._.lt = tagCtxs.lt; // If a late path @some.path has not returned @some object, mark tag as late
                        tag._.arrVws = {};
                    } else if (tag.dataBoundOnly) {
                        error(tagName + " must be data-bound:\n{^{" + tagName + "}}");
                    }
                    //TODO better perf for childTags() - keep child tag.tags array, (and remove child, when disposed)
                    // tag.tags = [];
                } else if (linkCtx && linkCtx.fn._lr) {
                    callInit = !!tag.init;
                }
                tagDataMap = tag.dataMap;

                tagCtx.tag = tag;
                if (tagDataMap && tagCtxs) {
                    tagCtx.map = tagCtxs[i].map; // Copy over the compiled map instance from the previous tagCtxs to the refreshed ones
                }
                if (!tag.flow) {
                    tagCtxCtx = tagCtx.ctx = tagCtx.ctx || {};

                    // tags hash: tag.ctx.tags, merged with parentView.ctx.tags,
                    tags = tag.parents = tagCtxCtx.parentTags = ctx && extendCtx(tagCtxCtx.parentTags, ctx.parentTags) || {};
                    if (parentTag) {
                        tags[parentTag.tagName] = parentTag;
                        //TODO better perf for childTags: parentTag.tags.push(tag);
                    }
                    tags[tag.tagName] = tagCtxCtx.tag = tag;
                    tagCtxCtx.tagCtx = tagCtx;
                }
            }
            if (!(tag._er = onError)) {
                tagHandlersFromProps(tag, tagCtxs[0]);
                tag.rendering = {rndr: tag.rendering}; // Provide object for state during render calls to tag and elses. (Used by {{if}} and {{for}}...)
                for (i = 0; i < l; i++) { // Iterate tagCtx for each {{else}} block
                    tagCtx = tag.tagCtx = tagCtxs[i];
                    props = tagCtx.props;
                    tag.ctx = tagCtx.ctx;

                    if (!i) {
                        if (callInit) {
                            tag.init(tagCtx, linkCtx, tag.ctx);
                            callInit = undefined;
                        }
                        if (!tagCtx.args.length && tagCtx.argDefault !== false && tag.argDefault !== false) {
                            tagCtx.args = args = [tagCtx.view.data]; // Missing first arg defaults to the current data context
                            tagCtx.params.args = ["#data"];
                        }

                        bindTo = bindToOrBindFrom("bindTo");

                        if (tag.bindTo !== undefined) {
                            tag.bindTo = bindTo;
                        }

                        if (tag.bindFrom !== undefined) {
                            tag.bindFrom = bindToOrBindFrom("bindFrom");
                        } else if (tag.bindTo) {
                            tag.bindFrom = tag.bindTo = bindTo;
                        }
                        bindFrom = tag.bindFrom || bindTo;

                        bindToLength = bindTo.length;
                        bindFromLength = bindFrom.length;

                        if (tag._.bnd && (linkedElement = tag.linkedElement)) {
                            tag.linkedElement = linkedElement = $isArray(linkedElement) ? linkedElement : [linkedElement];

                            if (bindToLength !== linkedElement.length) {
                                error("linkedElement not same length as bindTo");
                            }
                        }
                        if (linkedElement = tag.linkedCtxParam) {
                            tag.linkedCtxParam = linkedElement = $isArray(linkedElement) ? linkedElement : [linkedElement];

                            if (bindFromLength !== linkedElement.length) {
                                error("linkedCtxParam not same length as bindFrom/bindTo");
                            }
                        }

                        if (bindFrom) {
                            tag._.fromIndex = {}; // Hash of bindFrom index which has same path value as bindTo index. fromIndex = tag._.fromIndex[toIndex]
                            tag._.toIndex = {}; // Hash of bindFrom index which has same path value as bindTo index. fromIndex = tag._.fromIndex[toIndex]
                            n = bindFromLength;
                            while (n--) {
                                key = bindFrom[n];
                                m = bindToLength;
                                while (m--) {
                                    if (key === bindTo[m]) {
                                        tag._.fromIndex[m] = n;
                                        tag._.toIndex[n] = m;
                                    }
                                }
                            }
                        }

                        if (linkCtx) {
                            // Set attr on linkCtx to ensure outputting to the correct target attribute.
                            // Setting either linkCtx.attr or this.attr in the init() allows per-instance choice of target attrib.
                            linkCtx.attr = tag.attr = linkCtx.attr || tag.attr || linkCtx._dfAt;
                        }
                        attr = tag.attr;
                        tag._.noVws = attr && attr !== HTML;
                    }
                    args = tag.cvtArgs(i);
                    if (tag.linkedCtxParam) {
                        bdArgs = tag.cvtArgs(i, 1);
                        m = bindFromLength;
                        defaultCtx = tag.constructor.prototype.ctx;
                        while (m--) {
                            if (ctxPrm = tag.linkedCtxParam[m]) {
                                key = bindFrom[m];
                                initVal = bdArgs[m];
                                // Create tag contextual parameter
                                tagCtx.ctx[ctxPrm] = $sub._cp(
                                    defaultCtx && initVal === undefined ? defaultCtx[ctxPrm] : initVal,
                                    initVal !== undefined && argOrProp(tagCtx.params, key),
                                    tagCtx.view,
                                    tag._.bnd && {tag: tag, cvt: tag.convert, ind: m, tagElse: i}
                                );
                            }
                        }
                    }
                    if ((mapDef = props.dataMap || tagDataMap) && (args.length || props.dataMap)) {
                        thisMap = tagCtx.map;
                        if (!thisMap || thisMap.src !== args[0] || isUpdate) {
                            if (thisMap && thisMap.src) {
                                thisMap.unmap(); // only called if observable map - not when only used in JsRender, e.g. by {{props}}
                            }
                            mapDef.map(args[0], tagCtx, thisMap, !tag._.bnd);
                            thisMap = tagCtx.map;
                        }
                        args = [thisMap.tgt];
                    }

                    itemRet = undefined;
                    if (tag.render) {
                        itemRet = tag.render.apply(tag, args);
                        if (parentView.linked && itemRet && !rWrappedInViewMarker.test(itemRet)) {
                            // When a tag renders content from the render method, with data linking then we need to wrap with view markers, if absent,
                            // to provide a contentView for the tag, which will correctly dispose bindings if deleted. The 'tmpl' for this view will
                            // be a dumbed-down template which will always return the  itemRet string (no matter what the data is). The itemRet string
                            // is not compiled as template markup, so can include "{{" or "}}" without triggering syntax errors
                            tmpl = { // 'Dumbed-down' template which always renders 'static' itemRet string
                                links: []
                            };
                            tmpl.render = tmpl.fn = function () {
                                return itemRet;
                            };
                            itemRet = renderWithViews(tmpl, parentView.data, undefined, true, parentView, undefined, undefined, tag);
                        }
                    }
                    if (!args.length) {
                        args = [parentView]; // no arguments - (e.g. {{else}}) get data context from view.
                    }
                    if (itemRet === undefined) {
                        contentCtx = args[0]; // Default data context for wrapped block content is the first argument
                        if (tag.contentCtx) { // Set tag.contentCtx to true, to inherit parent context, or to a function to provide alternate context.
                            contentCtx = tag.contentCtx === true ? parentView : tag.contentCtx(contentCtx);
                        }
                        itemRet = tagCtx.render(contentCtx, true) || (isUpdate ? undefined : "");
                    }
                    ret = ret
                        ? ret + (itemRet || "")
                        : itemRet !== undefined
                            ? "" + itemRet
                            : undefined; // If no return value from render, and no template/content tagCtx.render(...), return undefined
                }
                tag.rendering = tag.rendering.rndr; // Remove tag.rendering object (if this is outermost render call. (In case of nested calls)
            }
            tag.tagCtx = tagCtxs[0];
            tag.ctx = tag.tagCtx.ctx;

            if (tag._.noVws && tag.inline) {
                // inline tag with attr set to "text" will insert HTML-encoded content - as if it was element-based innerText
                ret = attr === "text"
                    ? $converters.html(ret)
                    : "";
            }
            return boundTag && parentView._.onRender
                // Call onRender (used by JsViews if present, to add binding annotations around rendered content)
                ? parentView._.onRender(ret, parentView, tag)
                : ret;
        }

//=================
// View constructor
//=================

        function View(context, type, parentView, data, template, key, onRender, contentTmpl) {
            // Constructor for view object in view hierarchy. (Augmented by JsViews if JsViews is loaded)
            var views, parentView_, tag, self_,
                self = this,
                isArray = type === "array";
            // If the data is an array, this is an 'array view' with a views array for each child 'item view'
            // If the data is not an array, this is an 'item view' with a views 'hash' object for any child nested views

            self.content = contentTmpl;
            self.views = isArray ? [] : {};
            self.data = data;
            self.tmpl = template;
            self_ = self._ = {
                key: 0,
                // ._.useKey is non zero if is not an 'array view' (owning a data array). Use this as next key for adding to child views hash
                useKey: isArray ? 0 : 1,
                id: "" + viewId++,
                onRender: onRender,
                bnds: {}
            };
            self.linked = !!onRender;
            self.type = type || "top";
            if (self.parent = parentView) {
                self.root = parentView.root || self; // view whose parent is top view
                views = parentView.views;
                parentView_ = parentView._;
                self.isTop = parentView_.scp; // Is top content view of a link("#container", ...) call
                self.scope = (!context.tag || context.tag === parentView.ctx.tag) && !self.isTop && parentView.scope || self;
                // Scope for contextParams - closest non flow tag ancestor or root view
                if (parentView_.useKey) {
                    // Parent is not an 'array view'. Add this view to its views object
                    // self._key = is the key in the parent view hash
                    views[self_.key = "_" + parentView_.useKey++] = self;
                    self.index = indexStr;
                    self.getIndex = getNestedIndex;
                } else if (views.length === (self_.key = self.index = key)) { // Parent is an 'array view'. Add this view to its views array
                    views.push(self); // Adding to end of views array. (Using push when possible - better perf than splice)
                } else {
                    views.splice(key, 0, self); // Inserting in views array
                }
                // If no context was passed in, use parent context
                // If context was passed in, it should have been merged already with parent context
                self.ctx = context || parentView.ctx;
            } else {
                self.ctx = context || {};
            }
        }

        View.prototype = {
            get: getView,
            getIndex: getIndex,
            ctxPrm: contextParameter,
            getRsc: getResource,
            _getTmpl: getTemplate,
            _getOb: getPathObject,
            _is: "view"
        };

//====================================================
// Registration
//====================================================

        function compileChildResources(parentTmpl) {
            var storeName, storeNames, resources;
            for (storeName in jsvStores) {
                storeNames = storeName + "s";
                if (parentTmpl[storeNames]) {
                    resources = parentTmpl[storeNames];    // Resources not yet compiled
                    parentTmpl[storeNames] = {};               // Remove uncompiled resources
                    $views[storeNames](resources, parentTmpl); // Add back in the compiled resources
                }
            }
        }

//===============
// compileTag
//===============

        function compileTag(name, tagDef, parentTmpl) {
            var tmpl, baseTag, prop,
                compiledDef = new $sub._tg();

            function Tag() {
                var tag = this;
                tag._ = {
                    unlinked: true
                };
                tag.inline = true;
                tag.tagName = name;
            }

            if ($isFunction(tagDef)) {
                // Simple tag declared as function. No presenter instantation.
                tagDef = {
                    depends: tagDef.depends,
                    render: tagDef
                };
            } else if ("" + tagDef === tagDef) {
                tagDef = {template: tagDef};
            }

            if (baseTag = tagDef.baseTag) {
                tagDef.flow = !!tagDef.flow; // Set flow property, so defaults to false even if baseTag has flow=true
                baseTag = "" + baseTag === baseTag
                    ? (parentTmpl && parentTmpl.tags[baseTag] || $tags[baseTag])
                    : baseTag;
                if (!baseTag) {
                    error('baseTag: "' + tagDef.baseTag + '" not found');
                }
                compiledDef = $extend(compiledDef, baseTag);

                for (prop in tagDef) {
                    compiledDef[prop] = getMethod(baseTag[prop], tagDef[prop]);
                }
            } else {
                compiledDef = $extend(compiledDef, tagDef);
            }

            // Tag declared as object, used as the prototype for tag instantiation (control/presenter)
            if ((tmpl = compiledDef.template) !== undefined) {
                compiledDef.template = "" + tmpl === tmpl ? ($templates[tmpl] || $templates(tmpl)) : tmpl;
            }
            (Tag.prototype = compiledDef).constructor = compiledDef._ctr = Tag;

            if (parentTmpl) {
                compiledDef._parentTmpl = parentTmpl;
            }
            return compiledDef;
        }

        function baseApply(args) {
            // In derived method (or handler declared declaratively as in {{:foo onChange=~fooChanged}} can call base method,
            // using this.baseApply(arguments) (Equivalent to this._superApply(arguments) in jQuery UI)
            return this.base.apply(this, args);
        }

//===============
// compileTmpl
//===============

        function compileTmpl(name, tmpl, parentTmpl, options) {
            // tmpl is either a template object, a selector for a template script block, the name of a compiled template, or a template object

            //==== nested functions ====
            function lookupTemplate(value) {
                // If value is of type string - treat as selector, or name of compiled template
                // Return the template object, if already compiled, or the markup string
                var currentName, tmpl;
                if (("" + value === value) || value.nodeType > 0 && (elem = value)) {
                    if (!elem) {
                        if (/^\.\/[^\\:*?"<>]*$/.test(value)) {
                            // tmpl="./some/file.html"
                            // If the template is not named, use "./some/file.html" as name.
                            if (tmpl = $templates[name = name || value]) {
                                value = tmpl;
                            } else {
                                // BROWSER-SPECIFIC CODE (not on Node.js):
                                // Look for server-generated script block with id "./some/file.html"
                                elem = document.getElementById(value);
                            }
                        } else if ($.fn && !$sub.rTmpl.test(value)) {
                            try {
                                elem = $(value, document)[0]; // if jQuery is loaded, test for selector returning elements, and get first element
                            } catch (e) {
                            }
                        }// END BROWSER-SPECIFIC CODE
                    } //BROWSER-SPECIFIC CODE
                    if (elem) {
                        if (elem.tagName !== "SCRIPT") {
                            error(value + ": Use script block, not " + elem.tagName);
                        }
                        if (options) {
                            // We will compile a new template using the markup in the script element
                            value = elem.innerHTML;
                        } else {
                            // We will cache a single copy of the compiled template, and associate it with the name
                            // (renaming from a previous name if there was first).
                            currentName = elem.getAttribute(tmplAttr);
                            if (currentName) {
                                if (currentName !== jsvTmpl) {
                                    value = $templates[currentName];
                                    delete $templates[currentName];
                                } else if ($.fn) {
                                    value = $.data(elem)[jsvTmpl]; // Get cached compiled template
                                }
                            }
                            if (!currentName || !value) { // Not yet compiled, or cached version lost
                                name = name || ($.fn ? jsvTmpl : value);
                                value = compileTmpl(name, elem.innerHTML, parentTmpl, options);
                            }
                            value.tmplName = name = name || currentName;
                            if (name !== jsvTmpl) {
                                $templates[name] = value;
                            }
                            elem.setAttribute(tmplAttr, name);
                            if ($.fn) {
                                $.data(elem, jsvTmpl, value);
                            }
                        }
                    } // END BROWSER-SPECIFIC CODE
                    elem = undefined;
                } else if (!value.fn) {
                    value = undefined;
                    // If value is not a string. HTML element, or compiled template, return undefined
                }
                return value;
            }

            var elem, compiledTmpl,
                tmplOrMarkup = tmpl = tmpl || "";
            $sub._html = $converters.html;

            //==== Compile the template ====
            if (options === 0) {
                options = undefined;
                tmplOrMarkup = lookupTemplate(tmplOrMarkup); // Top-level compile so do a template lookup
            }

            // If options, then this was already compiled from a (script) element template declaration.
            // If not, then if tmpl is a template object, use it for options
            options = options || (tmpl.markup
                    ? tmpl.bnds
                        ? $extend({}, tmpl)
                        : tmpl
                    : {}
            );

            options.tmplName = options.tmplName || name || "unnamed";
            if (parentTmpl) {
                options._parentTmpl = parentTmpl;
            }
            // If tmpl is not a markup string or a selector string, then it must be a template object
            // In that case, get it from the markup property of the object
            if (!tmplOrMarkup && tmpl.markup && (tmplOrMarkup = lookupTemplate(tmpl.markup)) && tmplOrMarkup.fn) {
                // If the string references a compiled template object, need to recompile to merge any modified options
                tmplOrMarkup = tmplOrMarkup.markup;
            }
            if (tmplOrMarkup !== undefined) {
                if (tmplOrMarkup.render || tmpl.render) {
                    // tmpl is already compiled, so use it
                    if (tmplOrMarkup.tmpls) {
                        compiledTmpl = tmplOrMarkup;
                    }
                } else {
                    // tmplOrMarkup is a markup string, not a compiled template
                    // Create template object
                    tmpl = tmplObject(tmplOrMarkup, options);
                    // Compile to AST and then to compiled function
                    tmplFn(tmplOrMarkup.replace(rEscapeQuotes, "\\$&"), tmpl);
                }
                if (!compiledTmpl) {
                    compiledTmpl = $extend(function () {
                        return compiledTmpl.render.apply(compiledTmpl, arguments);
                    }, tmpl);

                    compileChildResources(compiledTmpl);
                }
                return compiledTmpl;
            }
        }

//==== /end of function compileTmpl ====

//=================
// compileViewModel
//=================

        function getDefaultVal(defaultVal, data) {
            return $isFunction(defaultVal)
                ? defaultVal.call(data)
                : defaultVal;
        }

        function unmapArray(modelArr) {
            var arr = [],
                i = 0,
                l = modelArr.length;
            for (; i < l; i++) {
                arr.push(modelArr[i].unmap());
            }
            return arr;
        }

        function compileViewModel(name, type) {
            var i, constructor,
                viewModels = this,
                getters = type.getters,
                extend = type.extend,
                id = type.id,
                proto = $.extend({
                    _is: name || "unnamed",
                    unmap: unmap,
                    merge: merge
                }, extend),
                args = "",
                body = "",
                g = getters ? getters.length : 0,
                $observable = $.observable,
                getterNames = {};

            function GetNew(args) {
                constructor.apply(this, args);
            }

            function vm() {
                return new GetNew(arguments);
            }

            function iterate(data, action) {
                var getterType, defaultVal, prop, ob,
                    j = 0;
                for (; j < g; j++) {
                    prop = getters[j];
                    getterType = undefined;
                    if (prop + "" !== prop) {
                        getterType = prop;
                        prop = getterType.getter;
                    }
                    if ((ob = data[prop]) === undefined && getterType && (defaultVal = getterType.defaultVal) !== undefined) {
                        ob = getDefaultVal(defaultVal, data);
                    }
                    action(ob, getterType && viewModels[getterType.type], prop);
                }
            }

            function map(data) {
                data = data + "" === data
                    ? JSON.parse(data) // Accept JSON string
                    : data;            // or object/array
                var l, prop,
                    j = 0,
                    ob = data,
                    arr = [];

                if ($isArray(data)) {
                    data = data || [];
                    l = data.length;
                    for (; j < l; j++) {
                        arr.push(this.map(data[j]));
                    }
                    arr._is = name;
                    arr.unmap = unmap;
                    arr.merge = merge;
                    return arr;
                }

                if (data) {
                    iterate(data, function (ob, viewModel) {
                        if (viewModel) { // Iterate to build getters arg array (value, or mapped value)
                            ob = viewModel.map(ob);
                        }
                        arr.push(ob);
                    });

                    ob = this.apply(this, arr); // Instantiate this View Model, passing getters args array to constructor
                    for (prop in data) { // Copy over any other properties. that are not get/set properties
                        if (prop !== $expando && !getterNames[prop]) {
                            ob[prop] = data[prop];
                        }
                    }
                }
                return ob;
            }

            function merge(data) {
                data = data + "" === data
                    ? JSON.parse(data) // Accept JSON string
                    : data;            // or object/array
                var j, l, m, prop, mod, found, assigned, ob, newModArr,
                    k = 0,
                    model = this;

                if ($isArray(model)) {
                    assigned = {};
                    newModArr = [];
                    l = data.length;
                    m = model.length;
                    for (; k < l; k++) {
                        ob = data[k];
                        found = false;
                        for (j = 0; j < m && !found; j++) {
                            if (assigned[j]) {
                                continue;
                            }
                            mod = model[j];

                            if (id) {
                                assigned[j] = found = id + "" === id
                                    ? (ob[id] && (getterNames[id] ? mod[id]() : mod[id]) === ob[id])
                                    : id(mod, ob);
                            }
                        }
                        if (found) {
                            mod.merge(ob);
                            newModArr.push(mod);
                        } else {
                            newModArr.push(vm.map(ob));
                        }
                    }
                    if ($observable) {
                        $observable(model).refresh(newModArr, true);
                    } else {
                        model.splice.apply(model, [0, model.length].concat(newModArr));
                    }
                    return;
                }
                iterate(data, function (ob, viewModel, getter) {
                    if (viewModel) {
                        model[getter]().merge(ob); // Update typed property
                    } else {
                        model[getter](ob); // Update non-typed property
                    }
                });
                for (prop in data) {
                    if (prop !== $expando && !getterNames[prop]) {
                        model[prop] = data[prop];
                    }
                }
            }

            function unmap() {
                var ob, prop, getterType, arr, value,
                    k = 0,
                    model = this;

                if ($isArray(model)) {
                    return unmapArray(model);
                }
                ob = {};
                for (; k < g; k++) {
                    prop = getters[k];
                    getterType = undefined;
                    if (prop + "" !== prop) {
                        getterType = prop;
                        prop = getterType.getter;
                    }
                    value = model[prop]();
                    ob[prop] = getterType && value && viewModels[getterType.type]
                        ? $isArray(value)
                            ? unmapArray(value)
                            : value.unmap()
                        : value;
                }
                for (prop in model) {
                    if (prop !== "_is" && !getterNames[prop] && prop !== $expando && (prop.charAt(0) !== "_" || !getterNames[prop.slice(1)]) && !$isFunction(model[prop])) {
                        ob[prop] = model[prop];
                    }
                }
                return ob;
            }

            GetNew.prototype = proto;

            for (i = 0; i < g; i++) {
                (function (getter) {
                    getter = getter.getter || getter;
                    getterNames[getter] = i + 1;
                    var privField = "_" + getter;

                    args += (args ? "," : "") + getter;
                    body += "this." + privField + " = " + getter + ";\n";
                    proto[getter] = proto[getter] || function (val) {
                        if (!arguments.length) {
                            return this[privField]; // If there is no argument, use as a getter
                        }
                        if ($observable) {
                            $observable(this).setProperty(getter, val);
                        } else {
                            this[privField] = val;
                        }
                    };

                    if ($observable) {
                        proto[getter].set = proto[getter].set || function (val) {
                            this[privField] = val; // Setter called by observable property change
                        };
                    }
                })(getters[i]);
            }

            constructor = new Function(args, body.slice(0, -1));
            constructor.prototype = proto;
            proto.constructor = constructor;

            vm.map = map;
            vm.getters = getters;
            vm.extend = extend;
            vm.id = id;
            return vm;
        }

        function tmplObject(markup, options) {
            // Template object constructor
            var htmlTag,
                wrapMap = $subSettingsAdvanced._wm || {}, // Only used in JsViews. Otherwise empty: {}
                tmpl = {
                    tmpls: [],
                    links: {}, // Compiled functions for link expressions
                    bnds: [],
                    _is: "template",
                    render: renderContent
                };

            if (options) {
                tmpl = $extend(tmpl, options);
            }

            tmpl.markup = markup;
            if (!tmpl.htmlTag) {
                // Set tmpl.tag to the top-level HTML tag used in the template, if any...
                htmlTag = rFirstElem.exec(markup);
                tmpl.htmlTag = htmlTag ? htmlTag[1].toLowerCase() : "";
            }
            htmlTag = wrapMap[tmpl.htmlTag];
            if (htmlTag && htmlTag !== wrapMap.div) {
                // When using JsViews, we trim templates which are inserted into HTML contexts where text nodes are not rendered (i.e. not 'Phrasing Content').
                // Currently not trimmed for <li> tag. (Not worth adding perf cost)
                tmpl.markup = $.trim(tmpl.markup);
            }

            return tmpl;
        }

//==============
// registerStore
//==============

        /**
         * Internal. Register a store type (used for template, tags, helpers, converters)
         */
        function registerStore(storeName, storeSettings) {

            /**
             * Generic store() function to register item, named item, or hash of items
             * Also used as hash to store the registered items
             * Used as implementation of $.templates(), $.views.templates(), $.views.tags(), $.views.helpers() and $.views.converters()
             *
             * @param {string|hash} name         name - or selector, in case of $.templates(). Or hash of items
             * @param {any}         [item]       (e.g. markup for named template)
             * @param {template}    [parentTmpl] For item being registered as private resource of template
             * @returns {any|$.views} item, e.g. compiled template - or $.views in case of registering hash of items
             */
            function theStore(name, item, parentTmpl) {
                // The store is also the function used to add items to the store. e.g. $.templates, or $.views.tags

                // For store of name 'thing', Call as:
                //    $.views.things(items[, parentTmpl]),
                // or $.views.things(name[, item, parentTmpl])

                var compile, itemName, thisStore, cnt,
                    onStore = $sub.onStore[storeName];

                if (name && typeof name === OBJECT && !name.nodeType && !name.markup && !name.getTgt && !(storeName === "viewModel" && name.getters || name.extend)) {
                    // Call to $.views.things(items[, parentTmpl]),

                    // Adding items to the store
                    // If name is a hash, then item is parentTmpl. Iterate over hash and call store for key.
                    for (itemName in name) {
                        theStore(itemName, name[itemName], item);
                    }
                    return item || $views;
                }
                // Adding a single unnamed item to the store
                if (item === undefined) {
                    item = name;
                    name = undefined;
                }
                if (name && "" + name !== name) { // name must be a string
                    parentTmpl = item;
                    item = name;
                    name = undefined;
                }
                thisStore = parentTmpl
                    ? storeName === "viewModel"
                        ? parentTmpl
                        : (parentTmpl[storeNames] = parentTmpl[storeNames] || {})
                    : theStore;
                compile = storeSettings.compile;

                if (item === null) {
                    // If item is null, delete this entry
                    if (name) {
                        delete thisStore[name];
                    }
                } else {
                    if (compile) {
                        item = compile.call(thisStore, name, item, parentTmpl, 0) || {};
                        item._is = storeName; // Only do this for compiled objects (tags, templates...)
                    }
                    if (name) {
                        thisStore[name] = item;
                    }
                }
                if (onStore) {
                    // e.g. JsViews integration
                    onStore(name, item, parentTmpl, compile);
                }
                return item;
            }

            var storeNames = storeName + "s";
            $views[storeNames] = theStore;
        }

        /**
         * Add settings such as:
         * $.views.settings.allowCode(true)
         * @param {boolean}  value
         * @returns {Settings}
         *
         * allowCode = $.views.settings.allowCode()
         * @returns {boolean}
         */
        function addSetting(st) {
            $viewsSettings[st] = function (value) {
                return arguments.length
                    ? ($subSettings[st] = value, $viewsSettings)
                    : $subSettings[st];
            };
        }

//========================
// dataMap for render only
//========================

        function dataMap(mapDef) {
            function Map(source, options) {
                this.tgt = mapDef.getTgt(source, options);
                options.map = this;
            }

            if ($isFunction(mapDef)) {
                // Simple map declared as function
                mapDef = {
                    getTgt: mapDef
                };
            }

            if (mapDef.baseMap) {
                mapDef = $extend($extend({}, mapDef.baseMap), mapDef);
            }

            mapDef.map = function (source, options) {
                return new Map(source, options);
            };
            return mapDef;
        }

//==============
// renderContent
//==============

        /** Render the template as a string, using the specified data and helpers/context
         * $("#tmpl").render(), tmpl.render(), tagCtx.render(), $.render.namedTmpl()
         *
         * @param {any}        data
         * @param {hash}       [context]           helpers or context
         * @param {boolean}    [noIteration]
         * @param {View}       [parentView]        internal
         * @param {string}     [key]               internal
         * @param {function}   [onRender]          internal
         * @returns {string}   rendered template   internal
         */
        function renderContent(data, context, noIteration, parentView, key, onRender) {
            var i, l, tag, tmpl, tagCtx, isTopRenderCall, prevData, prevIndex,
                view = parentView,
                result = "";

            if (context === true) {
                noIteration = context; // passing boolean as second param - noIteration
                context = undefined;
            } else if (typeof context !== OBJECT) {
                context = undefined; // context must be a boolean (noIteration) or a plain object
            }

            if (tag = this.tag) {
                // This is a call from renderTag or tagCtx.render(...)
                tagCtx = this;
                view = view || tagCtx.view;
                tmpl = view._getTmpl(tag.template || tagCtx.tmpl);
                if (!arguments.length) {
                    data = tag.contentCtx && $isFunction(tag.contentCtx)
                        ? data = tag.contentCtx(data)
                        : view; // Default data context for wrapped block content is the first argument
                }
            } else {
                // This is a template.render(...) call
                tmpl = this;
            }

            if (tmpl) {
                if (!parentView && data && data._is === "view") {
                    view = data; // When passing in a view to render or link (and not passing in a parent view) use the passed-in view as parentView
                }

                if (view && data === view) {
                    // Inherit the data from the parent view.
                    data = view.data;
                }

                isTopRenderCall = !view;
                isRenderCall = isRenderCall || isTopRenderCall;
                if (!view) {
                    (context = context || {}).root = data; // Provide ~root as shortcut to top-level data.
                }
                if (!isRenderCall || $subSettingsAdvanced.useViews || tmpl.useViews || view && view !== topView) {
                    result = renderWithViews(tmpl, data, context, noIteration, view, key, onRender, tag);
                } else {
                    if (view) { // In a block
                        prevData = view.data;
                        prevIndex = view.index;
                        view.index = indexStr;
                    } else {
                        view = topView;
                        prevData = view.data;
                        view.data = data;
                        view.ctx = context;
                    }
                    if ($isArray(data) && !noIteration) {
                        // Create a view for the array, whose child views correspond to each data item. (Note: if key and parentView are passed in
                        // along with parent view, treat as insert -e.g. from view.addViews - so parentView is already the view item for array)
                        for (i = 0, l = data.length; i < l; i++) {
                            view.index = i;
                            view.data = data[i];
                            result += tmpl.fn(data[i], view, $sub);
                        }
                    } else {
                        view.data = data;
                        result += tmpl.fn(data, view, $sub);
                    }
                    view.data = prevData;
                    view.index = prevIndex;
                }
                if (isTopRenderCall) {
                    isRenderCall = undefined;
                }
            }
            return result;
        }

        function renderWithViews(tmpl, data, context, noIteration, view, key, onRender, tag) {
            function setItemVar(item) {
                // When itemVar is specified, set modified ctx with user-named ~item
                newCtx = $extend({}, context);
                newCtx[itemVar] = item;
            }

            // Render template against data as a tree of subviews (nested rendered template instances), or as a string (top-level template).
            // If the data is the parent view, treat as noIteration, re-render with the same data context.
            // tmpl can be a string (e.g. rendered by a tag.render() method), or a compiled template.
            var i, l, newView, childView, itemResult, swapContent, contentTmpl, outerOnRender, tmplName, itemVar,
                newCtx, tagCtx, noLinking,
                result = "";

            if (tag) {
                // This is a call from renderTag or tagCtx.render(...)
                tmplName = tag.tagName;
                tagCtx = tag.tagCtx;
                context = context ? extendCtx(context, tag.ctx) : tag.ctx;

                if (tmpl === view.content) { // {{xxx tmpl=#content}}
                    contentTmpl = tmpl !== view.ctx._wrp // We are rendering the #content
                        ? view.ctx._wrp // #content was the tagCtx.props.tmpl wrapper of the block content - so within this view, #content will now be the view.ctx._wrp block content
                        : undefined; // #content was the view.ctx._wrp block content - so within this view, there is no longer any #content to wrap.
                } else if (tmpl !== tagCtx.content) {
                    if (tmpl === tag.template) { // Rendering {{tag}} tag.template, replacing block content.
                        contentTmpl = tagCtx.tmpl; // Set #content to block content (or wrapped block content if tagCtx.props.tmpl is set)
                        context._wrp = tagCtx.content; // Pass wrapped block content to nested views
                    } else { // Rendering tagCtx.props.tmpl wrapper
                        contentTmpl = tagCtx.content || view.content; // Set #content to wrapped block content
                    }
                } else {
                    contentTmpl = view.content; // Nested views inherit same wrapped #content property
                }

                if (tagCtx.props.link === false) {
                    // link=false setting on block tag
                    // We will override inherited value of link by the explicit setting link=false taken from props
                    // The child views of an unlinked view are also unlinked. So setting child back to true will not have any effect.
                    context = context || {};
                    context.link = false;
                }
                if (itemVar = tagCtx.props.itemVar) {
                    if (itemVar[0] !== "~") {
                        syntaxError("Use itemVar='~myItem'");
                    }
                    itemVar = itemVar.slice(1);
                }
            }

            if (view) {
                onRender = onRender || view._.onRender;
                noLinking = context && context.link === false;

                if (noLinking && view._.nl) {
                    onRender = undefined;
                }

                context = extendCtx(context, view.ctx);
            }

            if (key === true) {
                swapContent = true;
                key = 0;
            }

            // If link===false, do not call onRender, so no data-linking marker nodes
            if (onRender && tag && tag._.noVws) {
                onRender = undefined;
            }
            outerOnRender = onRender;
            if (onRender === true) {
                // Used by view.refresh(). Don't create a new wrapper view.
                outerOnRender = undefined;
                onRender = view._.onRender;
            }
            // Set additional context on views created here, (as modified context inherited from the parent, and to be inherited by child views)
            context = tmpl.helpers
                ? extendCtx(tmpl.helpers, context)
                : context;

            newCtx = context;
            if ($isArray(data) && !noIteration) {
                // Create a view for the array, whose child views correspond to each data item. (Note: if key and view are passed in
                // along with parent view, treat as insert -e.g. from view.addViews - so view is already the view item for array)
                newView = swapContent
                    ? view
                    : (key !== undefined && view)
                    || new View(context, "array", view, data, tmpl, key, onRender, contentTmpl);
                newView._.nl = noLinking;
                if (view && view._.useKey) {
                    // Parent is not an 'array view'
                    newView._.bnd = !tag || tag._.bnd && tag; // For array views that are data bound for collection change events, set the
                    // view._.bnd property to true for top-level link() or data-link="{for}", or to the tag instance for a data-bound tag, e.g. {^{for ...}}
                    newView.tag = tag;
                }
                for (i = 0, l = data.length; i < l; i++) {
                    // Create a view for each data item.
                    if (itemVar) {
                        setItemVar(data[i]); // use modified ctx with user-named ~item
                    }
                    childView = new View(newCtx, "item", newView, data[i], tmpl, (key || 0) + i, onRender, newView.content);
                    childView._.it = itemVar;

                    itemResult = tmpl.fn(data[i], childView, $sub);
                    result += newView._.onRender ? newView._.onRender(itemResult, childView) : itemResult;
                }
            } else {
                // Create a view for singleton data object. The type of the view will be the tag name, e.g. "if" or "mytag" except for
                // "item", "array" and "data" views. A "data" view is from programmatic render(object) against a 'singleton'.
                if (itemVar) {
                    setItemVar(data);
                }
                newView = swapContent ? view : new View(newCtx, tmplName || "data", view, data, tmpl, key, onRender, contentTmpl);
                newView._.it = itemVar;
                newView.tag = tag;
                newView._.nl = noLinking;
                result += tmpl.fn(data, newView, $sub);
            }
            if (tag) {
                newView.tagElse = tagCtx.index;
                tagCtx.contentView = newView;
            }
            return outerOnRender ? outerOnRender(result, newView) : result;
        }

//===========================
// Build and compile template
//===========================

// Generate a reusable function that will serve to render a template against data
// (Compile AST then build template function)

        function onRenderError(e, view, fallback) {
            var message = fallback !== undefined
                ? $isFunction(fallback)
                    ? fallback.call(view.data, e, view)
                    : fallback || ""
                : "{Error: " + (e.message || e) + "}";

            if ($subSettings.onError && (fallback = $subSettings.onError.call(view.data, e, fallback && message, view)) !== undefined) {
                message = fallback; // There is a settings.debugMode(handler) onError override. Call it, and use return value (if any) to replace message
            }

            return view && !view._lc ? $converters.html(message) : message;
        }

        function error(message) {
            throw new $sub.Err(message);
        }

        function syntaxError(message) {
            error("Syntax error\n" + message);
        }

        function tmplFn(markup, tmpl, isLinkExpr, convertBack, hasElse) {
            // Compile markup to AST (abtract syntax tree) then build the template function code from the AST nodes
            // Used for compiling templates, and also by JsViews to build functions for data link expressions

            //==== nested functions ====
            function pushprecedingContent(shift) {
                shift -= loc;
                if (shift) {
                    content.push(markup.substr(loc, shift).replace(rNewLine, "\\n"));
                }
            }

            function blockTagCheck(tagName, block) {
                if (tagName) {
                    tagName += '}}';
                    //			'{{include}} block has {{/for}} with no open {{for}}'
                    syntaxError((
                        block
                            ? '{{' + block + '}} block has {{/' + tagName + ' without {{' + tagName
                            : 'Unmatched or missing {{/' + tagName) + ', in template:\n' + markup);
                }
            }

            function parseTag(all, bind, tagName, converter, colon, html, codeTag, params, slash, bind2, closeBlock, index) {
                /*

                     bind     tagName         cvt   cln html code    params            slash   bind2         closeBlk  comment
                /(?:{(\^)?{(?:(\w+(?=[\/\s}]))|(\w+)?(:)|(>)|(\*))\s*((?:[^}]|}(?!}))*?)(\/)?|{(\^)?{(?:(?:\/(\w+))\s*|!--[\s\S]*?--))}}/g

                (?:
                  {(\^)?{            bind
                  (?:
                    (\w+             tagName
                      (?=[\/\s}])
                    )
                    |
                    (\w+)?(:)        converter colon
                    |
                    (>)              html
                    |
                    (\*)             codeTag
                  )
                  \s*
                  (                  params
                    (?:[^}]|}(?!}))*?
                  )
                  (\/)?              slash
                  |
                  {(\^)?{            bind2
                  (?:
                    (?:\/(\w+))\s*   closeBlock
                    |
                    !--[\s\S]*?--    comment
                  )
                )
                }}/g

                */
                if (codeTag && bind || slash && !tagName || params && params.slice(-1) === ":" || bind2) {
                    syntaxError(all);
                }

                // Build abstract syntax tree (AST): [tagName, converter, params, content, hash, bindings, contentMarkup]
                if (html) {
                    colon = ":";
                    converter = HTML;
                }
                slash = slash || isLinkExpr && !hasElse;

                var late, openTagName, isLateOb,
                    pathBindings = (bind || isLinkExpr) && [[]], // pathBindings is an array of arrays for arg bindings and a hash of arrays for prop bindings
                    props = "",
                    args = "",
                    ctxProps = "",
                    paramsArgs = "",
                    paramsProps = "",
                    paramsCtxProps = "",
                    onError = "",
                    useTrigger = "",
                    // Block tag if not self-closing and not {{:}} or {{>}} (special case) and not a data-link expression
                    block = !slash && !colon;

                //==== nested helper function ====
                tagName = tagName || (params = params || "#data", colon); // {{:}} is equivalent to {{:#data}}
                pushprecedingContent(index);
                loc = index + all.length; // location marker - parsed up to here
                if (codeTag) {
                    if (allowCode) {
                        content.push(["*", "\n" + params.replace(/^:/, "ret+= ").replace(rUnescapeQuotes, "$1") + ";\n"]);
                    }
                } else if (tagName) {
                    if (tagName === "else") {
                        if (rTestElseIf.test(params)) {
                            syntaxError('For "{{else if expr}}" use "{{else expr}}"');
                        }
                        pathBindings = current[9] && [[]];
                        current[10] = markup.substring(current[10], index); // contentMarkup for block tag
                        openTagName = current[11] || current[0] || syntaxError("Mismatched: " + all);
                        // current[0] is tagName, but for {{else}} nodes, current[11] is tagName of preceding open tag
                        current = stack.pop();
                        content = current[2];
                        block = true;
                    }
                    if (params) {
                        // remove newlines from the params string, to avoid compiled code errors for unterminated strings
                        parseParams(params.replace(rNewLine, " "), pathBindings, tmpl, isLinkExpr)
                            .replace(rBuildHash, function (all, onerror, isCtxPrm, key, keyToken, keyValue, arg, param) {
                                if (key === "this:") {
                                    keyValue = "undefined"; // this=some.path is always a to parameter (first-way), so don't need to compile/evaluate some.path initialization
                                }
                                if (param) {
                                    isLateOb = isLateOb || param[0] === "@";
                                }
                                key = "'" + keyToken + "':";
                                if (arg) {
                                    args += isCtxPrm + keyValue + ",";
                                    paramsArgs += "'" + param + "',";
                                } else if (isCtxPrm) { // Contextual parameter, ~foo=expr
                                    ctxProps += key + 'j._cp(' + keyValue + ',"' + param + '",view),';
                                    // Compiled code for evaluating tagCtx on a tag will have: ctx:{'foo':j._cp(compiledExpr, "expr", view)}
                                    paramsCtxProps += key + "'" + param + "',";
                                } else if (onerror) {
                                    onError += keyValue;
                                } else {
                                    if (keyToken === "trigger") {
                                        useTrigger += keyValue;
                                    }
                                    if (keyToken === "lateRender") {
                                        late = param !== "false"; // Render after first pass
                                    }
                                    props += key + keyValue + ",";
                                    paramsProps += key + "'" + param + "',";
                                    hasHandlers = hasHandlers || rHasHandlers.test(keyToken);
                                }
                                return "";
                            }).slice(0, -1);
                    }

                    if (pathBindings && pathBindings[0]) {
                        pathBindings.pop(); // Remove the binding that was prepared for next arg. (There is always an extra first ready).
                    }

                    newNode = [
                        tagName,
                        converter || !!convertBack || hasHandlers || "",
                        block && [],
                        parsedParam(paramsArgs || (tagName === ":" ? "'#data'," : ""), paramsProps, paramsCtxProps), // {{:}} equivalent to {{:#data}}
                        parsedParam(args || (tagName === ":" ? "data," : ""), props, ctxProps),
                        onError,
                        useTrigger,
                        late,
                        isLateOb,
                        pathBindings || 0
                    ];
                    content.push(newNode);
                    if (block) {
                        stack.push(current);
                        current = newNode;
                        current[10] = loc; // Store current location of open tag, to be able to add contentMarkup when we reach closing tag
                        current[11] = openTagName; // Used for checking syntax (matching close tag)
                    }
                } else if (closeBlock) {
                    blockTagCheck(closeBlock !== current[0] && closeBlock !== current[11] && closeBlock, current[0]); // Check matching close tag name
                    current[10] = markup.substring(current[10], index); // contentMarkup for block tag
                    current = stack.pop();
                }
                blockTagCheck(!current && closeBlock);
                content = current[2];
            }

            //==== /end of nested functions ====

            var i, result, newNode, hasHandlers, bindings,
                allowCode = $subSettings.allowCode || tmpl && tmpl.allowCode
                    || $viewsSettings.allowCode === true, // include direct setting of settings.allowCode true for backward compat only
                astTop = [],
                loc = 0,
                stack = [],
                content = astTop,
                current = [, , astTop];

            if (allowCode && tmpl._is) {
                tmpl.allowCode = allowCode;
            }

//TODO	result = tmplFnsCache[markup]; // Only cache if template is not named and markup length < ...,
//and there are no bindings or subtemplates?? Consider standard optimization for data-link="a.b.c"
//		if (result) {
//			tmpl.fn = result;
//		} else {

//		result = markup;
            if (isLinkExpr) {
                if (convertBack !== undefined) {
                    markup = markup.slice(0, -convertBack.length - 2) + delimCloseChar0;
                }
                markup = delimOpenChar0 + markup + delimCloseChar1;
            }

            blockTagCheck(stack[0] && stack[0][2].pop()[0]);
            // Build the AST (abstract syntax tree) under astTop
            markup.replace(rTag, parseTag);

            pushprecedingContent(markup.length);

            if (loc = astTop[astTop.length - 1]) {
                blockTagCheck("" + loc !== loc && (+loc[10] === loc[10]) && loc[0]);
            }
//			result = tmplFnsCache[markup] = buildCode(astTop, tmpl);
//		}

            if (isLinkExpr) {
                result = buildCode(astTop, markup, isLinkExpr);
                bindings = [];
                i = astTop.length;
                while (i--) {
                    bindings.unshift(astTop[i][9]); // With data-link expressions, pathBindings array for tagCtx[i] is astTop[i][9]
                }
                setPaths(result, bindings);
            } else {
                result = buildCode(astTop, tmpl);
            }
            return result;
        }

        function setPaths(fn, pathsArr) {
            var key, paths,
                i = 0,
                l = pathsArr.length;
            fn.deps = [];
            fn.paths = []; // The array of path binding (array/dictionary)s for each tag/else block's args and props
            for (; i < l; i++) {
                fn.paths.push(paths = pathsArr[i]);
                for (key in paths) {
                    if (key !== "_jsvto" && paths.hasOwnProperty(key) && paths[key].length && !paths[key].skp) {
                        fn.deps = fn.deps.concat(paths[key]); // deps is the concatenation of the paths arrays for the different bindings
                    }
                }
            }
        }

        function parsedParam(args, props, ctx) {
            return [args.slice(0, -1), props.slice(0, -1), ctx.slice(0, -1)];
        }

        function paramStructure(parts, type) {
            return '\n\t'
                + (type
                    ? type + ':{'
                    : '')
                + 'args:[' + parts[0] + '],\n\tprops:{' + parts[1] + '}'
                + (parts[2] ? ',\n\tctx:{' + parts[2] + '}' : "");
        }

        function parseParams(params, pathBindings, tmpl, isLinkExpr) {

            function parseTokens(all, lftPrn0, lftPrn, bound, path, operator, err, eq, path2, late, prn, comma, lftPrn2, apos, quot, rtPrn, rtPrnDot, prn2, space, index, full) {
                // /(\()(?=\s*\()|(?:([([])\s*)?(?:(\^?)(~?[\w$.^]+)?\s*((\+\+|--)|\+|-|&&|\|\||===|!==|==|!=|<=|>=|[<>%*:?\/]|(=))\s*|(!*?(@)?[#~]?[\w$.^]+)([([])?)|(,\s*)|(\(?)\\?(?:(')|("))|(?:\s*(([)\]])(?=[.^]|\s*$|[^([])|[)\]])([([]?))|(\s+)/g,
                //  lftPrn0          lftPrn        bound path             operator err                                         eq      path2 late            prn      comma  lftPrn2   apos quot        rtPrn  rtPrnDot                  prn2     space
                // (left paren? followed by (path? followed by operator) or (path followed by paren?)) or comma or apos or quot or right paren or space
                function parsePath(allPath, not, object, helper, view, viewProperty, pathTokens, leafToken) {
                    //rPath = /^(!*?)(?:null|true|false|\d[\d.]*|([\w$]+|\.|~([\w$]+)|#(view|([\w$]+))?)([\w$.^]*?)(?:[.[^]([\w$]+)\]?)?)$/g,
                    //          not                               object     helper    view  viewProperty pathTokens      leafToken
                    var subPath = object === ".";
                    if (object) {
                        path = path.slice(not.length);
                        if (/^\.?constructor$/.test(leafToken || path)) {
                            syntaxError(allPath);
                        }
                        if (!subPath) {
                            allPath = (late // late path @a.b.c: not throw on 'property of undefined' if a undefined, and will use _getOb() after linking to resolve late.
                                    ? (isLinkExpr ? '' : '(ltOb.lt=ltOb.lt||') + '(ob='
                                    : ""
                                )
                                + (helper
                                    ? 'view.ctxPrm("' + helper + '")'
                                    : view
                                        ? "view"
                                        : "data")
                                + (late
                                        ? ')===undefined' + (isLinkExpr ? '' : ')') + '?"":view._getOb(ob,"'
                                        : ""
                                )
                                + (leafToken
                                    ? (viewProperty
                                        ? "." + viewProperty
                                        : helper
                                            ? ""
                                            : (view ? "" : "." + object)
                                ) + (pathTokens || "")
                                    : (leafToken = helper ? "" : view ? viewProperty || "" : object, ""));
                            allPath = allPath + (leafToken ? "." + leafToken : "");

                            allPath = not + (allPath.slice(0, 9) === "view.data"
                                ? allPath.slice(5) // convert #view.data... to data...
                                : allPath)
                                + (late
                                        ? (isLinkExpr ? '"' : '",ltOb') + (prn ? ',1)' : ')')
                                        : ""
                                );
                        }
                        if (bindings) {
                            binds = named === "_linkTo" ? (bindto = pathBindings._jsvto = pathBindings._jsvto || []) : bndCtx.bd;
                            if (theOb = subPath && binds[binds.length - 1]) {
                                if (theOb._cpfn) { // Computed property exprOb
                                    while (theOb.sb) {
                                        theOb = theOb.sb;
                                    }
                                    if (theOb.bnd) {
                                        path = "^" + path.slice(1);
                                    }
                                    theOb.sb = path;
                                    theOb.bnd = theOb.bnd || path[0] === "^";
                                }
                            } else {
                                binds.push(path);
                            }
                            pathStart[parenDepth] = index + (subPath ? 1 : 0);
                        }
                    }
                    return allPath;
                }

                //bound = bindings && bound;
                if (bound && !eq) {
                    path = bound + path; // e.g. some.fn(...)^some.path - so here path is "^some.path"
                }
                operator = operator || "";
                lftPrn = lftPrn || lftPrn0 || lftPrn2;
                path = path || path2;

                if (late && (late = !/\)|]/.test(full[index - 1]))) {
                    path = path.slice(1).split(".").join("^"); // Late path @z.b.c. Use "^" rather than "." to ensure that deep binding will be used
                }
                // Could do this - but not worth perf cost?? :-
                // if (!path.lastIndexOf("#data.", 0)) { path = path.slice(6); } // If path starts with "#data.", remove that.
                prn = prn || prn2 || "";

                var expr, exprFn, binds, theOb, newOb,
                    rtSq = ")";

                if (prn === "[") {
                    prn = "[j._sq(";
                    rtSq = ")]";
                }

                if (err && !aposed && !quoted) {
                    syntaxError(params);
                } else {
                    if (bindings && rtPrnDot && !aposed && !quoted) {
                        // This is a binding to a path in which an object is returned by a helper/data function/expression, e.g. foo()^x.y or (a?b:c)^x.y
                        // We create a compiled function to get the object instance (which will be called when the dependent data of the subexpression changes, to return the new object, and trigger re-binding of the subsequent path)
                        if (parenDepth && (!named || boundName || bindto)) {
                            expr = pathStart[parenDepth - 1];
                            if (full.length - 1 > index - (expr || 0)) { // We need to compile a subexpression
                                expr = full.slice(expr, index + all.length);
                                if (exprFn !== true) { // If not reentrant call during compilation
                                    binds = bindto || bndStack[parenDepth - 1].bd;
                                    // Insert exprOb object, to be used during binding to return the computed object
                                    theOb = binds[binds.length - 1];
                                    if (theOb && theOb.prm) {
                                        while (theOb.sb && theOb.sb.prm) {
                                            theOb = theOb.sb;
                                        }
                                        newOb = theOb.sb = {path: theOb.sb, bnd: theOb.bnd};
                                    } else {
                                        binds.push(newOb = {path: binds.pop()}); // Insert exprOb object, to be used during binding to return the computed object
                                    }											 // (e.g. "some.object()" in "some.object().a.b" - to be used as context for binding the following tokens "a.b")
                                }
                                rtPrnDot = delimOpenChar1 + ":" + expr // The parameter or function subexpression
                                    + " onerror=''" // set onerror='' in order to wrap generated code with a try catch - returning '' as object instance if there is an error/missing parent
                                    + delimCloseChar0;
                                exprFn = tmplLinks[rtPrnDot];
                                if (!exprFn) {
                                    tmplLinks[rtPrnDot] = true; // Flag that this exprFn (for rtPrnDot) is being compiled
                                    tmplLinks[rtPrnDot] = exprFn = tmplFn(rtPrnDot, tmpl, true); // Compile the expression (or use cached copy already in tmpl.links)
                                }
                                if (exprFn !== true && newOb) {
                                    // If not reentrant call during compilation
                                    newOb._cpfn = exprFn;
                                    newOb.prm = bndCtx.bd;
                                    newOb.bnd = newOb.bnd || newOb.path && newOb.path.indexOf("^") >= 0;
                                }
                            }
                        }
                    }
                    return (aposed
                            // within single-quoted string
                            ? (aposed = !apos, (aposed ? all : lftPrn2 + '"'))
                            : quoted
                                // within double-quoted string
                                ? (quoted = !quot, (quoted ? all : lftPrn2 + '"'))
                                :
                                (
                                    (lftPrn
                                        ? (pathStart[parenDepth] = index++, bndCtx = bndStack[++parenDepth] = {bd: []}, lftPrn)
                                        : "")
                                    + (space
                                        ? (parenDepth
                                                ? ""
                                                // New arg or prop - so insert backspace \b (\x08) as separator for named params, used subsequently by rBuildHash, and prepare new bindings array
                                                : (paramIndex = full.slice(paramIndex, index), named
                                                ? (named = boundName = bindto = false, "\b")
                                                : "\b,") + paramIndex + (paramIndex = index + all.length, bindings && pathBindings.push(bndCtx.bd = []), "\b")
                                        )
                                        : eq
                                            // named param. Remove bindings for arg and create instead bindings array for prop
                                            ? (parenDepth && syntaxError(params), bindings && pathBindings.pop(), named = "_" + path, boundName = bound, paramIndex = index + all.length,
                                            bindings && ((bindings = bndCtx.bd = pathBindings[named] = []), bindings.skp = !bound), path + ':')
                                            : path
                                                // path
                                                ? (path.split("^").join(".").replace(rPath, parsePath)
                                                    + (prn
                                                        // some.fncall(
                                                        ? (bndCtx = bndStack[++parenDepth] = {bd: []}, fnCall[parenDepth] = rtSq, prn)
                                                        : operator)
                                                )
                                                : operator
                                                    // operator
                                                    ? operator
                                                    : rtPrn
                                                        // function
                                                        ? ((rtPrn = fnCall[parenDepth] || rtPrn, fnCall[parenDepth] = false, bndCtx = bndStack[--parenDepth], rtPrn)
                                                            + (prn // rtPrn and prn, e.g )( in (a)() or a()(), or )[ in a()[]
                                                                ? (bndCtx = bndStack[++parenDepth], fnCall[parenDepth] = rtSq, prn)
                                                                : "")
                                                        )
                                                        : comma
                                                            ? (fnCall[parenDepth] || syntaxError(params), ",") // We don't allow top-level literal arrays or objects
                                                            : lftPrn0
                                                                ? ""
                                                                : (aposed = apos, quoted = quot, '"')
                                    ))
                    );
                }
            }

            var named, bindto, boundName,
                quoted, // boolean for string content in double quotes
                aposed, // or in single quotes
                bindings = pathBindings && pathBindings[0], // bindings array for the first arg
                bndCtx = {bd: bindings},
                bndStack = {0: bndCtx},
                paramIndex = 0, // list,
                tmplLinks = (tmpl ? tmpl.links : bindings && (bindings.links = bindings.links || {})) || topView.tmpl.links,
                // The following are used for tracking path parsing including nested paths, such as "a.b(c^d + (e))^f", and chained computed paths such as
                // "a.b().c^d().e.f().g" - which has four chained paths, "a.b()", "^c.d()", ".e.f()" and ".g"
                parenDepth = 0,
                fnCall = {}, // We are in a function call
                pathStart = {}, // tracks the start of the current path such as c^d() in the above example
                result;

            if (params[0] === "@") {
                params = params.replace(rBracketQuote, ".");
            }
            result = (params + (tmpl ? " " : "")).replace(rParams, parseTokens);

            return !parenDepth && result || syntaxError(params); // Syntax error if unbalanced parens in params expression
        }

        function buildCode(ast, tmpl, isLinkExpr) {
            // Build the template function code from the AST nodes, and set as property on the passed-in template object
            // Used for compiling templates, and also by JsViews to build functions for data link expressions
            var i, node, tagName, converter, tagCtx, hasTag, hasEncoder, getsVal, hasCnvt, useCnvt, tmplBindings,
                pathBindings, params, boundOnErrStart,
                boundOnErrEnd, tagRender, nestedTmpls, tmplName, nestedTmpl, tagAndElses, content, markup, nextIsElse,
                oldCode, isElse, isGetVal, tagCtxFn,
                onError, tagStart, trigger, lateRender, retStrOpen, retStrClose,
                tmplBindingKey = 0,
                useViews = $subSettingsAdvanced.useViews || tmpl.useViews || tmpl.tags || tmpl.templates || tmpl.helpers || tmpl.converters,
                code = "",
                tmplOptions = {},
                l = ast.length;

            if ("" + tmpl === tmpl) {
                tmplName = isLinkExpr ? 'data-link="' + tmpl.replace(rNewLine, " ").slice(1, -1) + '"' : tmpl;
                tmpl = 0;
            } else {
                tmplName = tmpl.tmplName || "unnamed";
                if (tmpl.allowCode) {
                    tmplOptions.allowCode = true;
                }
                if (tmpl.debug) {
                    tmplOptions.debug = true;
                }
                tmplBindings = tmpl.bnds;
                nestedTmpls = tmpl.tmpls;
            }
            for (i = 0; i < l; i++) {
                // AST nodes: [0: tagName, 1: converter, 2: content, 3: params, 4: code, 5: onError, 6: trigger, 7:pathBindings, 8: contentMarkup]
                node = ast[i];

                // Add newline for each callout to t() c() etc. and each markup string
                if ("" + node === node) {
                    // a markup string to be inserted
                    code += '\n+"' + node + '"';
                } else {
                    // a compiled tag expression to be inserted
                    tagName = node[0];
                    if (tagName === "*") {
                        // Code tag: {{* }}
                        code += ";\n" + node[1] + "\nret=ret";
                    } else {
                        converter = node[1];
                        content = !isLinkExpr && node[2];
                        tagCtx = paramStructure(node[3], 'params') + '},' + paramStructure(params = node[4]);
                        trigger = node[6];
                        lateRender = node[7];
                        if (node[8]) { // latePath @a.b.c or @~a.b.c
                            retStrOpen = "\nvar ob,ltOb={},ctxs=";
                            retStrClose = ";\nctxs.lt=ltOb.lt;\nreturn ctxs;";
                        } else {
                            retStrOpen = "\nreturn ";
                            retStrClose = "";
                        }
                        markup = node[10] && node[10].replace(rUnescapeQuotes, "$1");
                        if (isElse = tagName === "else") {
                            if (pathBindings) {
                                pathBindings.push(node[9]);
                            }
                        } else {
                            onError = node[5] || $subSettings.debugMode !== false && "undefined"; // If debugMode not false, set default onError handler on tag to "undefined" (see onRenderError)
                            if (tmplBindings && (pathBindings = node[9])) { // Array of paths, or false if not data-bound
                                pathBindings = [pathBindings];
                                tmplBindingKey = tmplBindings.push(1); // Add placeholder in tmplBindings for compiled function
                            }
                        }
                        useViews = useViews || params[1] || params[2] || pathBindings || /view.(?!index)/.test(params[0]);
                        // useViews is for perf optimization. For render() we only use views if necessary - for the more advanced scenarios.
                        // We use views if there are props, contextual properties or args with #... (other than #index) - but you can force
                        // using the full view infrastructure, (and pay a perf price) by opting in: Set useViews: true on the template, manually...
                        if (isGetVal = tagName === ":") {
                            if (converter) {
                                tagName = converter === HTML ? ">" : converter + tagName;
                            }
                        } else {
                            if (content) { // TODO optimize - if content.length === 0 or if there is a tmpl="..." specified - set content to null / don't run this compilation code - since content won't get used!!
                                // Create template object for nested template
                                nestedTmpl = tmplObject(markup, tmplOptions);
                                nestedTmpl.tmplName = tmplName + "/" + tagName;
                                // Compile to AST and then to compiled function
                                nestedTmpl.useViews = nestedTmpl.useViews || useViews;
                                buildCode(content, nestedTmpl);
                                useViews = nestedTmpl.useViews;
                                nestedTmpls.push(nestedTmpl);
                            }

                            if (!isElse) {
                                // This is not an else tag.
                                tagAndElses = tagName;
                                useViews = useViews || tagName && (!$tags[tagName] || !$tags[tagName].flow);
                                // Switch to a new code string for this bound tag (and its elses, if it has any) - for returning the tagCtxs array
                                oldCode = code;
                                code = "";
                            }
                            nextIsElse = ast[i + 1];
                            nextIsElse = nextIsElse && nextIsElse[0] === "else";
                        }
                        tagStart = onError ? ";\ntry{\nret+=" : "\n+";
                        boundOnErrStart = "";
                        boundOnErrEnd = "";

                        if (isGetVal && (pathBindings || trigger || converter && converter !== HTML || lateRender)) {
                            // For convertVal we need a compiled function to return the new tagCtx(s)
                            tagCtxFn = new Function("data,view,j,u", "// " + tmplName + " " + (++tmplBindingKey) + " " + tagName
                                + retStrOpen + "{" + tagCtx + "};" + retStrClose);
                            tagCtxFn._er = onError;
                            tagCtxFn._tag = tagName;
                            tagCtxFn._bd = !!pathBindings; // data-linked tag {^{.../}}
                            tagCtxFn._lr = lateRender;

                            if (isLinkExpr) {
                                return tagCtxFn;
                            }

                            setPaths(tagCtxFn, pathBindings);
                            tagRender = 'c("' + converter + '",view,';
                            useCnvt = true;
                            boundOnErrStart = tagRender + tmplBindingKey + ",";
                            boundOnErrEnd = ")";
                        }
                        code += (isGetVal
                            ? (isLinkExpr ? (onError ? "try{\n" : "") + "return " : tagStart) + (useCnvt // Call _cnvt if there is a converter: {{cnvt: ... }} or {^{cnvt: ... }}
                                ? (useCnvt = undefined, useViews = hasCnvt = true, tagRender + (tagCtxFn
                                    ? ((tmplBindings[tmplBindingKey - 1] = tagCtxFn), tmplBindingKey) // Store the compiled tagCtxFn in tmpl.bnds, and pass the key to convertVal()
                                    : "{" + tagCtx + "}") + ")")
                                : tagName === ">"
                                    ? (hasEncoder = true, "h(" + params[0] + ")")
                                    : (getsVal = true, "((v=" + params[0] + ')!=null?v:' + (isLinkExpr ? 'null)' : '"")'))
                            // Non strict equality so data-link="title{:expr}" with expr=null/undefined removes title attribute
                        )
                            : (hasTag = true, "\n{view:view,content:false,tmpl:" // Add this tagCtx to the compiled code for the tagCtxs to be passed to renderTag()
                            + (content ? nestedTmpls.length : "false") + "," // For block tags, pass in the key (nestedTmpls.length) to the nested content template
                            + tagCtx + "},"));

                        if (tagAndElses && !nextIsElse) {
                            // This is a data-link expression or an inline tag without any elses, or the last {{else}} of an inline tag
                            // We complete the code for returning the tagCtxs array
                            code = "[" + code.slice(0, -1) + "]";
                            tagRender = 't("' + tagAndElses + '",view,this,';
                            if (isLinkExpr || pathBindings) {
                                // This is a bound tag (data-link expression or inline bound tag {^{tag ...}}) so we store a compiled tagCtxs function in tmp.bnds
                                code = new Function("data,view,j,u", " // " + tmplName + " " + tmplBindingKey + " " + tagAndElses + retStrOpen + code
                                    + retStrClose);
                                code._er = onError;
                                code._tag = tagAndElses;
                                if (pathBindings) {
                                    setPaths(tmplBindings[tmplBindingKey - 1] = code, pathBindings);
                                }
                                code._lr = lateRender;
                                if (isLinkExpr) {
                                    return code; // For a data-link expression we return the compiled tagCtxs function
                                }
                                boundOnErrStart = tagRender + tmplBindingKey + ",undefined,";
                                boundOnErrEnd = ")";
                            }

                            // This is the last {{else}} for an inline tag.
                            // For a bound tag, pass the tagCtxs fn lookup key to renderTag.
                            // For an unbound tag, include the code directly for evaluating tagCtxs array
                            code = oldCode + tagStart + tagRender + (pathBindings && tmplBindingKey || code) + ")";
                            pathBindings = 0;
                            tagAndElses = 0;
                        }
                        if (onError && !nextIsElse) {
                            useViews = true;
                            code += ';\n}catch(e){ret' + (isLinkExpr ? "urn " : "+=") + boundOnErrStart + 'j._err(e,view,' + onError + ')' + boundOnErrEnd + ';}' + (isLinkExpr ? "" : 'ret=ret');
                        }
                    }
                }
            }
            // Include only the var references that are needed in the code
            code = "// " + tmplName
                + (tmplOptions.debug ? "\ndebugger;" : "")
                + "\nvar v"
                + (hasTag ? ",t=j._tag" : "")                // has tag
                + (hasCnvt ? ",c=j._cnvt" : "")              // converter
                + (hasEncoder ? ",h=j._html" : "")           // html converter
                + (isLinkExpr
                    ? (node[8]  // late @... path?
                        ? ", ob"
                        : ""
                ) + ";\n"
                    : ',ret=""')
                + code
                + (isLinkExpr ? "\n" : ";\nreturn ret;");

            try {
                code = new Function("data,view,j,u", code);
            } catch (e) {
                syntaxError("Compiled template code:\n\n" + code + '\n: "' + (e.message || e) + '"');
            }
            if (tmpl) {
                tmpl.fn = code;
                tmpl.useViews = !!useViews;
            }
            return code;
        }

//==========
// Utilities
//==========

// Merge objects, in particular contexts which inherit from parent contexts
        function extendCtx(context, parentContext) {
            // Return copy of parentContext, unless context is defined and is different, in which case return a new merged context
            // If neither context nor parentContext are defined, return undefined
            return context && context !== parentContext
                ? (parentContext
                    ? $extend($extend({}, parentContext), context)
                    : context)
                : parentContext && $extend({}, parentContext);
        }

        function getTargetProps(source, tagCtx) {
            // this pointer is theMap - which has tagCtx.props too
            // arguments: tagCtx.args.
            var key, prop,
                props = [];

            if (typeof source === OBJECT || $isFunction(source)) {
                for (key in source) {
                    prop = source[key];
                    if (key !== $expando && source.hasOwnProperty(key) && (!tagCtx.props.noFunctions || !$.isFunction(prop))) {
                        props.push({key: key, prop: prop});
                    }
                }
            }
            return getTargetSorted(props, tagCtx);
        }

        function getTargetSorted(value, tagCtx) {
            // getTgt
            var mapped, start, end,
                tag = tagCtx.tag,
                props = tagCtx.props,
                propParams = tagCtx.params.props,
                filter = props.filter,
                sort = props.sort,
                directSort = sort === true,
                step = parseInt(props.step),
                reverse = props.reverse ? -1 : 1;

            if (!$isArray(value)) {
                return value;
            }
            if (directSort || sort && "" + sort === sort) {
                // Temporary mapped array holds objects with index and sort-value
                mapped = value.map(function (item, i) {
                    item = directSort ? item : getPathObject(item, sort);
                    return {i: i, v: "" + item === item ? item.toLowerCase() : item};
                });
                // Sort mapped array
                mapped.sort(function (a, b) {
                    return a.v > b.v ? reverse : a.v < b.v ? -reverse : 0;
                });
                // Map to new array with resulting order
                value = mapped.map(function (item) {
                    return value[item.i];
                });
            } else if ((sort || reverse < 0) && !tag.dataMap) {
                value = value.slice(); // Clone array first if not already a new array
            }
            if ($isFunction(sort)) {
                value = value.sort(sort);
            }
            if (reverse < 0 && !sort) { // Reverse result if not already reversed in sort
                value = value.reverse();
            }

            if (value.filter && filter) { // IE8 does not support filter
                value = value.filter(filter, tagCtx);
                if (tagCtx.tag.onFilter) {
                    tagCtx.tag.onFilter(tagCtx);
                }
            }

            if (propParams.sorted) {
                mapped = (sort || reverse < 0) ? value : value.slice();
                if (tag.sorted) {
                    $.observable(tag.sorted).refresh(mapped); // Note that this might cause the start and end props to be modified - e.g. by pager tag control
                } else {
                    tagCtx.map.sorted = mapped;
                }
            }

            start = props.start; // Get current value - after possible  changes triggered by tag.sorted refresh() above
            end = props.end;
            if (propParams.start && start === undefined || propParams.end && end === undefined) {
                start = end = 0;
            }
            if (!isNaN(start) || !isNaN(end)) { // start or end specified, but not the auto-create Number array scenario of {{for start=xxx end=yyy}}
                start = +start || 0;
                end = end === undefined || end > value.length ? value.length : +end;
//		end = end === undefined ? value.length : +end;
                value = value.slice(start, end);
            }
            if (step > 1) {
                start = 0;
                end = value.length;
                mapped = [];
                for (; start < end; start += step) {
                    mapped.push(value[start]);
                }
                value = mapped;
            }
            if (propParams.paged && tag.paged) {
                $observable(tag.paged).refresh(value);
            }

            return value;
        }

        /** Render the template as a string, using the specified data and helpers/context
         * $("#tmpl").render()
         *
         * @param {any}        data
         * @param {hash}       [helpersOrContext]
         * @param {boolean}    [noIteration]
         * @returns {string}   rendered template
         */
        function $fnRender(data, context, noIteration) {
            var tmplElem = this.jquery && (this[0] || error('Unknown template')), // Targeted element not found for jQuery template selector such as "#myTmpl"
                tmpl = tmplElem.getAttribute(tmplAttr);

            return renderContent.call(tmpl && $.data(tmplElem)[jsvTmpl] || $templates(tmplElem),
                data, context, noIteration);
        }

//========================== Register converters ==========================

        function getCharEntity(ch) {
            // Get character entity for HTML, Attribute and optional data encoding
            return charEntities[ch] || (charEntities[ch] = "&#" + ch.charCodeAt(0) + ";");
        }

        function getCharFromEntity(match, token) {
            // Get character from HTML entity, for optional data unencoding
            return charsFromEntities[token] || "";
        }

        function htmlEncode(text) {
            // HTML encode: Replace < > & ' " ` etc. by corresponding entities.
            return text != undefined ? rIsHtml.test(text) && ("" + text).replace(rHtmlEncode, getCharEntity) || text : "";
        }

        function dataEncode(text) {
            // Encode just < > and & - intended for 'safe data' along with {{:}} rather than {{>}}
            return "" + text === text ? text.replace(rDataEncode, getCharEntity) : text;
        }

        function dataUnencode(text) {
            // Unencode just < > and & - intended for 'safe data' along with {{:}} rather than {{>}}
            return "" + text === text ? text.replace(rDataUnencode, getCharFromEntity) : text;
        }

//========================== Initialize ==========================

        $sub = $views.sub;
        $viewsSettings = $views.settings;

        if (!(jsr || $ && $.render)) {
            // JsRender not already loaded, or loaded without jQuery, and we are now moving from jsrender namespace to jQuery namepace
            for (jsvStoreName in jsvStores) {
                registerStore(jsvStoreName, jsvStores[jsvStoreName]);
            }

            $converters = $views.converters;
            $helpers = $views.helpers;
            $tags = $views.tags;

            $sub._tg.prototype = {
                baseApply: baseApply,
                cvtArgs: convertArgs,
                bndArgs: convertBoundArgs,
                ctxPrm: contextParameter
            };

            topView = $sub.topView = new View();

            //BROWSER-SPECIFIC CODE
            if ($) {

                ////////////////////////////////////////////////////////////////////////////////////////////////
                // jQuery (= $) is loaded

                $.fn.render = $fnRender;
                $expando = $.expando;
                if ($.observable) {
                    if (versionNumber !== (versionNumber = $.views.jsviews)) {
                        // Different version of jsRender was loaded
                        throw "JsObservable requires JsRender " + versionNumber;
                    }
                    $extend($sub, $.views.sub); // jquery.observable.js was loaded before jsrender.js
                    $views.map = $.views.map;
                }

            } else {
                ////////////////////////////////////////////////////////////////////////////////////////////////
                // jQuery is not loaded.

                $ = {};

                if (setGlobals) {
                    global.jsrender = $; // We are loading jsrender.js from a script element, not AMD or CommonJS, so set global
                }

                // Error warning if jsrender.js is used as template engine on Node.js (e.g. Express or Hapi...)
                // Use jsrender-node.js instead...
                $.renderFile = $.__express = $.compile = function () {
                    throw "Node.js: use npm jsrender, or jsrender-node.js";
                };

                //END BROWSER-SPECIFIC CODE
                $.isFunction = function (ob) {
                    return typeof ob === "function";
                };

                $.isArray = Array.isArray || function (obj) {
                    return ({}.toString).call(obj) === "[object Array]";
                };

                $sub._jq = function (jq) { // private method to move from JsRender APIs from jsrender namespace to jQuery namespace
                    if (jq !== $) {
                        $extend(jq, $); // map over from jsrender namespace to jQuery namespace
                        $ = jq;
                        $.fn.render = $fnRender;
                        delete $.jsrender;
                        $expando = $.expando;
                    }
                };

                $.jsrender = versionNumber;
            }
            $subSettings = $sub.settings;
            $subSettings.allowCode = false;
            $isFunction = $.isFunction;
            $.render = $render;
            $.views = $views;
            $.templates = $templates = $views.templates;

            for (setting in $subSettings) {
                addSetting(setting);
            }

            /**
             * $.views.settings.debugMode(true)
             * @param {boolean}  debugMode
             * @returns {Settings}
             *
             * debugMode = $.views.settings.debugMode()
             * @returns {boolean}
             */
            ($viewsSettings.debugMode = function (debugMode) {
                return debugMode === undefined
                    ? $subSettings.debugMode
                    : (
                        $subSettings.debugMode = debugMode,
                            $subSettings.onError = debugMode + "" === debugMode
                                ? function () {
                                    return debugMode;
                                }
                                : $isFunction(debugMode)
                                    ? debugMode
                                    : undefined,
                            $viewsSettings);
            })(false); // jshint ignore:line

            $subSettingsAdvanced = $subSettings.advanced = {
                useViews: false,
                _jsv: false // For global access to JsViews store
            };

            //========================== Register tags ==========================

            $tags({
                "if": {
                    render: function (val) {
                        // This function is called once for {{if}} and once for each {{else}}.
                        // We will use the tag.rendering object for carrying rendering state across the calls.
                        // If not done (a previous block has not been rendered), look at expression for this block and render the block if expression is truthy
                        // Otherwise return ""
                        var self = this,
                            tagCtx = self.tagCtx,
                            ret = (self.rendering.done || !val && (tagCtx.args.length || !tagCtx.index))
                                ? ""
                                : (self.rendering.done = true,
                                    self.selected = tagCtx.index,
                                    undefined); // Test is satisfied, so render content on current context
                        return ret;
                    },
                    contentCtx: true, // Inherit parent view data context
                    flow: true
                },
                "for": {
                    sortDataMap: dataMap(getTargetSorted),
                    init: function (val, cloned) {
                        var l, tagCtx, props, sort,
                            self = this,
                            tagCtxs = self.tagCtxs;
                        l = tagCtxs.length;
                        while (l--) {
                            tagCtx = tagCtxs[l];
                            props = tagCtx.props;
                            tagCtx.argDefault = props.end === undefined || tagCtx.args.length > 0; // Default to #data except for auto-create range scenario {{for start=xxx end=yyy step=zzz}}

                            if (tagCtx.argDefault !== false && $isArray(tagCtx.args[0])
                                && (props.sort !== undefined || tagCtx.params.props.start || tagCtx.params.props.end || props.step !== undefined || props.filter || props.reverse)) {
                                props.dataMap = self.sortDataMap;
                            }
                        }
                    },
                    render: function (val) {
                        // This function is called once for {{for}} and once for each {{else}}.
                        // We will use the tag.rendering object for carrying rendering state across the calls.
                        var value, filter, srtField, isArray, i, sorted, end, step,
                            self = this,
                            tagCtx = self.tagCtx,
                            range = tagCtx.argDefault === false,
                            props = tagCtx.props,
                            iterate = range || tagCtx.args.length, // Not final else and not auto-create range
                            result = "",
                            done = 0;

                        if (!self.rendering.done) {
                            value = iterate ? val : tagCtx.view.data; // For the final else, defaults to current data without iteration.

                            if (range) {
                                range = props.reverse ? "unshift" : "push";
                                end = +props.end;
                                step = +props.step || 1;
                                value = []; // auto-create integer array scenario of {{for start=xxx end=yyy}}
                                for (i = +props.start || 0; (end - i) * step > 0; i += step) {
                                    value[range](i);
                                }
                            }
                            if (value !== undefined) {
                                isArray = $isArray(value);
                                result += tagCtx.render(value, !iterate || props.noIteration);
                                // Iterates if data is an array, except on final else - or if noIteration property
                                // set to true. (Use {{include}} to compose templates without array iteration)
                                done += isArray ? value.length : 1;
                            }
                            if (self.rendering.done = done) {
                                self.selected = tagCtx.index;
                            }
                            // If nothing was rendered we will look at the next {{else}}. Otherwise, we are done.
                        }
                        return result;
                    },
                    flow: true
                },
                props: {
                    baseTag: "for",
                    dataMap: dataMap(getTargetProps),
                    init: noop, // Don't execute the base init() of the "for" tag
                    flow: true
                },
                include: {
                    flow: true
                },
                "*": {
                    // {{* code... }} - Ignored if template.allowCode and $.views.settings.allowCode are false. Otherwise include code in compiled template
                    render: retVal,
                    flow: true
                },
                ":*": {
                    // {{:* returnedExpression }} - Ignored if template.allowCode and $.views.settings.allowCode are false. Otherwise include code in compiled template
                    render: retVal,
                    flow: true
                },
                dbg: $helpers.dbg = $converters.dbg = dbgBreak // Register {{dbg/}}, {{dbg:...}} and ~dbg() to throw and catch, as breakpoints for debugging.
            });

            $converters({
                html: htmlEncode,
                attr: htmlEncode, // Includes > encoding since rConvertMarkers in JsViews does not skip > characters in attribute strings
                encode: dataEncode,
                unencode: dataUnencode, // Includes > encoding since rConvertMarkers in JsViews does not skip > characters in attribute strings
                url: function (text) {
                    // URL encoding helper.
                    return text != undefined ? encodeURI("" + text) : text === null ? text : ""; // null returns null, e.g. to remove attribute. undefined returns ""
                }
            });
        }
//========================== Define default delimiters ==========================
        $subSettings = $sub.settings;
        $isArray = ($ || jsr).isArray;
        $viewsSettings.delimiters("{{", "}}", "^");

        if (jsrToJq) { // Moving from jsrender namespace to jQuery namepace - copy over the stored items (templates, converters, helpers...)
            jsr.views.sub._jq($);
        }
        return $ || jsr;
    }, window));
