/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;
import org.aoju.bus.tracer.binding.jms.TraceMessageProducer;

public final class TraceQueueSender
implements QueueSender {
    private final TraceMessageProducer messageProducer;
    private final QueueSender delegate;

    public TraceQueueSender(TraceMessageProducer messageProducer, QueueSender delegate) {
        this.messageProducer = messageProducer;
        this.delegate = delegate;
    }

    public Queue getQueue() throws JMSException {
        return this.delegate.getQueue();
    }

    public void send(Queue queue, Message message) throws JMSException {
        this.messageProducer.writeTraceContextToMessage(message);
        this.delegate.send(queue, message);
    }

    public void send(Queue queue, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.writeTraceContextToMessage(message);
        this.delegate.send(queue, message, deliveryMode, priority, timeToLive);
    }

    public void send(Message message) throws JMSException {
        this.messageProducer.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.messageProducer.send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.send(destination, message, deliveryMode, priority, timeToLive);
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageID(value);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.messageProducer.getDisableMessageID();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageTimestamp(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.messageProducer.getDisableMessageTimestamp();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.messageProducer.setDeliveryMode(deliveryMode);
    }

    public int getDeliveryMode() throws JMSException {
        return this.messageProducer.getDeliveryMode();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.messageProducer.setPriority(defaultPriority);
    }

    public int getPriority() throws JMSException {
        return this.messageProducer.getPriority();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.messageProducer.setTimeToLive(timeToLive);
    }

    public long getTimeToLive() throws JMSException {
        return this.messageProducer.getTimeToLive();
    }

    public Destination getDestination() throws JMSException {
        return this.messageProducer.getDestination();
    }

    public void close() throws JMSException {
        this.messageProducer.close();
    }
}

