/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.soap.config;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.binding.spring.soap.TraceClientInterceptor;
import org.aoju.bus.tracer.binding.spring.soap.TracendpointInterceptor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Role;
import org.springframework.ws.client.core.WebServiceTemplate;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.config.annotation.WsConfigurerAdapter;
import org.springframework.ws.server.EndpointInterceptor;

@Role(value=2)
@Configuration
public class TraceSpringWsConfiguration {
    @Autowired
    Backend backend;

    @Bean
    TracendpointInterceptor TraceEndpointInterceptor() {
        return new TracendpointInterceptor(this.backend, "default");
    }

    @Bean
    TraceClientInterceptor TraceClientInterceptor() {
        return new TraceClientInterceptor(this.backend, "default");
    }

    @Bean
    WsConfigurerAdapter TraceWsConfigurerAdapter(final TracendpointInterceptor TraceEndpointInterceptor) {
        return new WsConfigurerAdapter(){

            public void addInterceptors(List<EndpointInterceptor> interceptors) {
                super.addInterceptors(Collections.singletonList(TraceEndpointInterceptor));
            }
        };
    }

    @Bean(name={"org.aoju.bus.trace4j.binding.spring.http.RestTemplatePostProcessor"})
    WebServiceTemplatePostProcessor restTemplatePostProcessor(TraceClientInterceptor TraceClientInterceptor2) {
        return new WebServiceTemplatePostProcessor(TraceClientInterceptor2);
    }

    static class WebServiceTemplatePostProcessor
    implements BeanPostProcessor {
        final TraceClientInterceptor interceptor;

        WebServiceTemplatePostProcessor(TraceClientInterceptor interceptor) {
            this.interceptor = interceptor;
        }

        public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
            if (bean instanceof WebServiceTemplate) {
                WebServiceTemplate webServiceTemplate = (WebServiceTemplate)bean;
                ClientInterceptor[] interceptors = webServiceTemplate.getInterceptors();
                ClientInterceptor[] newInterceptors = interceptors != null ? Arrays.copyOf(interceptors, interceptors.length + 1) : new ClientInterceptor[1];
                newInterceptors[newInterceptors.length - 1] = this.interceptor;
                webServiceTemplate.setInterceptors(newInterceptors);
            }
            return bean;
        }

        public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
            return bean;
        }
    }
}

