/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.transport;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.aoju.bus.logger.Logger;

public class HttpHeaderTransport {
    Map<String, String> parse(String serialized) {
        StringTokenizer pairTokenizer = new StringTokenizer(serialized.trim(), ",");
        HashMap<String, String> context = new HashMap<String, String>();
        while (pairTokenizer.hasMoreTokens()) {
            String pairStr = pairTokenizer.nextToken();
            String[] keyValuePair = pairStr.split("=");
            if (keyValuePair.length != 2) continue;
            try {
                String key = URLDecoder.decode(keyValuePair[0], "UTF-8");
                String value = URLDecoder.decode(keyValuePair[1], "UTF-8");
                context.put(key, value);
            }
            catch (UnsupportedEncodingException e) {
                Logger.error((String)"Charset not found", (Object[])new Object[]{e});
            }
        }
        return context;
    }

    public Map<String, String> parse(List<String> serializedElements) {
        HashMap<String, String> contextMap = new HashMap<String, String>();
        for (String serializedElement : serializedElements) {
            contextMap.putAll(this.parse(serializedElement));
        }
        return contextMap;
    }

    public String render(Map<String, String> context) {
        StringBuilder sb = new StringBuilder(128);
        Iterator<Map.Entry<String, String>> iterator = context.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            try {
                String key = URLEncoder.encode(entry.getKey().trim(), "UTF-8");
                String value = URLEncoder.encode(entry.getValue().trim(), "UTF-8");
                sb.append(key).append('=').append(value);
                if (!iterator.hasNext()) continue;
                sb.append(',');
            }
            catch (UnsupportedEncodingException e) {
                Logger.error((String)"Charset not found", (Object[])new Object[]{e});
            }
        }
        return sb.toString();
    }
}

