/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.jaxws;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.consts.TraceConsts;

abstract class AbstractTraceHandler
implements SOAPHandler<SOAPMessageContext> {
    private static final Set<QName> HANDLED_HEADERS = Collections.unmodifiableSet(new HashSet<QName>(Collections.singleton(TraceConsts.SOAP_HEADER_QNAME)));
    protected final Backend Backend;

    public AbstractTraceHandler(Backend Backend2) {
        this.Backend = Backend2;
    }

    public final boolean handleMessage(SOAPMessageContext context) {
        if (this.isOutgoing((MessageContext)context)) {
            this.handleOutgoing(context);
        } else {
            this.handleIncoming(context);
        }
        return true;
    }

    private boolean isOutgoing(MessageContext messageContext) {
        Object outboundBoolean = messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        return outboundBoolean != null && (Boolean)outboundBoolean != false;
    }

    public void close(MessageContext context) {
    }

    protected abstract void handleIncoming(SOAPMessageContext var1);

    protected abstract void handleOutgoing(SOAPMessageContext var1);

    public Set<QName> getHeaders() {
        return HANDLED_HEADERS;
    }

    SOAPHeader getOrCreateHeader(SOAPMessage message) throws SOAPException {
        SOAPHeader header = message.getSOAPHeader();
        if (header == null) {
            header = message.getSOAPPart().getEnvelope().addHeader();
        }
        return header;
    }
}

