/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.context.async;

import java.util.Map;
import java.util.concurrent.Executor;
import org.aoju.bus.tracer.Backend;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.framework.AbstractAdvisingBeanPostProcessor;
import org.springframework.aop.framework.ReflectiveMethodInvocation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.AnnotationAsyncExecutionInterceptor;
import org.springframework.scheduling.annotation.AsyncAnnotationAdvisor;

public class PostTpicAsyncBeanPostProcessor
extends AbstractAdvisingBeanPostProcessor {
    @Autowired
    public PostTpicAsyncBeanPostProcessor(Executor executor, Backend backend) {
        this.advisor = new TpicPostAdvisor(executor, backend);
    }

    public int getOrder() {
        return 0;
    }

    static class DelegateTpicToThreadInterceptor
    extends AnnotationAsyncExecutionInterceptor {
        private final Backend backend;

        DelegateTpicToThreadInterceptor(Executor defaultExecutor, Backend backend) {
            super(defaultExecutor);
            this.backend = backend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object invoke(MethodInvocation invocation) throws Throwable {
            ReflectiveMethodInvocation methodInvocation;
            Object tpicObj;
            if (invocation instanceof ReflectiveMethodInvocation && (tpicObj = (methodInvocation = (ReflectiveMethodInvocation)invocation).getUserAttribute("TPIC")) instanceof Map) {
                Map tpic = (Map)tpicObj;
                this.backend.putAll(tpic);
            }
            try {
                Object object = invocation.proceed();
                return object;
            }
            finally {
                this.backend.clear();
            }
        }
    }

    static class TpicPostAdvisor
    extends AsyncAnnotationAdvisor {
        private final Executor executor;
        private final Backend backend;

        public TpicPostAdvisor(Executor executor, Backend backend) {
            this.executor = executor;
            this.backend = backend;
        }

        public Advice getAdvice() {
            return new DelegateTpicToThreadInterceptor(this.executor, this.backend);
        }
    }
}

