/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.jaxrs2;

import java.util.List;
import java.util.Map;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientRequestFilter;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import javax.ws.rs.ext.Provider;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;

@Provider
public class TraceClientFilter
implements ClientRequestFilter,
ClientResponseFilter {
    private final Backend backend;
    private final HttpHeaderTransport transportSerialization;

    public TraceClientFilter() {
        this(Builder.getBackend());
    }

    TraceClientFilter(Backend backend) {
        this.backend = backend;
        this.transportSerialization = new HttpHeaderTransport();
    }

    public void filter(ClientRequestContext requestContext) {
        if (!this.backend.isEmpty() && this.backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.OutgoingRequest)) {
            Map<String, String> filtered = this.backend.getConfiguration().filterDeniedParams(this.backend.copyToMap(), TraceFilterConfiguration.Channel.OutgoingRequest);
            requestContext.getHeaders().putSingle((Object)"TPIC", (Object)this.transportSerialization.render(filtered));
        }
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) {
        List serializedHeaders = (List)responseContext.getHeaders().get((Object)"TPIC");
        if (serializedHeaders != null && this.backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.IncomingResponse)) {
            Map<String, String> parsed = this.transportSerialization.parse(serializedHeaders);
            this.backend.putAll(this.backend.getConfiguration().filterDeniedParams(parsed, TraceFilterConfiguration.Channel.IncomingResponse));
        }
    }
}

