/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.soap;

import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.consts.TraceConsts;
import org.aoju.bus.tracer.transport.SoapHeaderTransport;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapHeaderException;
import org.springframework.ws.soap.SoapMessage;

abstract class AbstractTraceInterceptor {
    protected static final SoapHeaderTransport soapHeaderTransport = new SoapHeaderTransport();
    protected final Backend backend;
    protected final String profile;

    public AbstractTraceInterceptor(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
    }

    protected void parseContextFromSoapHeader(WebServiceMessage message, TraceFilterConfiguration.Channel channel) {
        if (message instanceof SoapMessage) {
            SoapHeader soapHeader;
            SoapMessage soapMessage = (SoapMessage)message;
            TraceFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
            if (filterConfiguration.shouldProcessContext(channel) && (soapHeader = soapMessage.getSoapHeader()) != null) {
                Iterator tpicHeaders;
                try {
                    tpicHeaders = soapHeader.examineHeaderElements(TraceConsts.SOAP_HEADER_QNAME);
                }
                catch (SoapHeaderException ignored) {
                    tpicHeaders = Collections.emptyList().iterator();
                }
                if (tpicHeaders.hasNext()) {
                    Map<String, String> parsedTpic = soapHeaderTransport.parseTpicHeader(((SoapHeaderElement)tpicHeaders.next()).getSource());
                    this.backend.putAll(filterConfiguration.filterDeniedParams(parsedTpic, channel));
                }
            }
        } else {
            Logger.info((String)"Message is obviously no soap message - Not instance of Spring-WS SoapMessage", (Object[])new Object[0]);
        }
    }

    protected void serializeContextToSoapHeader(WebServiceMessage message, TraceFilterConfiguration.Channel channel) {
        if (message instanceof SoapMessage) {
            SoapHeader soapHeader;
            SoapMessage soapMessage = (SoapMessage)message;
            TraceFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
            if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(channel) && (soapHeader = soapMessage.getSoapHeader()) != null) {
                Map<String, String> context = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), channel);
                soapHeaderTransport.renderSoapHeader(context, soapHeader.getResult());
            }
        } else {
            Logger.info((String)"Message is obviously no soap message - Not instance of Spring-WS SoapMessage", (Object[])new Object[0]);
        }
    }
}

