/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.soap;

import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.binding.spring.soap.AbstractTraceInterceptor;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.springframework.ws.client.WebServiceClientException;
import org.springframework.ws.client.support.interceptor.ClientInterceptor;
import org.springframework.ws.context.MessageContext;

public final class TraceClientInterceptor
extends AbstractTraceInterceptor
implements ClientInterceptor {
    public TraceClientInterceptor() {
        this(Builder.getBackend(), "default");
    }

    public TraceClientInterceptor(String profile) {
        this(Builder.getBackend(), profile);
    }

    public TraceClientInterceptor(Backend backend, String profile) {
        super(backend, profile);
    }

    public boolean handleRequest(MessageContext messageContext) {
        this.serializeContextToSoapHeader(messageContext.getRequest(), TraceFilterConfiguration.Channel.OutgoingRequest);
        return true;
    }

    public boolean handleResponse(MessageContext messageContext) {
        this.parseContextFromSoapHeader(messageContext.getResponse(), TraceFilterConfiguration.Channel.IncomingResponse);
        return true;
    }

    public boolean handleFault(MessageContext messageContext) {
        return this.handleResponse(messageContext);
    }

    public void afterCompletion(MessageContext messageContext, Exception ex) throws WebServiceClientException {
    }
}

