/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.quartz;

import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Trigger;

public class TraceContextInjector {
    private final Backend backend;
    private final String profile;

    public TraceContextInjector() {
        this(Builder.getBackend(), "default");
    }

    public TraceContextInjector(String profile) {
        this(Builder.getBackend(), profile);
    }

    TraceContextInjector(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
    }

    public void injectContext(Trigger trigger) {
        this.injectContext(trigger.getJobDataMap());
    }

    public void injectContext(JobDetail jobDetail) {
        this.injectContext(jobDetail.getJobDataMap());
    }

    public void injectContext(JobDataMap jobDataMap) {
        TraceFilterConfiguration configuration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && configuration.shouldProcessContext(TraceFilterConfiguration.Channel.AsyncDispatch)) {
            jobDataMap.put("TPIC", this.backend.getConfiguration(this.profile).filterDeniedParams(this.backend.copyToMap(), TraceFilterConfiguration.Channel.AsyncDispatch));
        }
    }
}

