/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.jms;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import org.aoju.bus.tracer.binding.jms.TraceMessageProducer;

public final class TraceTopicPublisher
implements TopicPublisher {
    private final TraceMessageProducer messageProducer;
    private final TopicPublisher delegate;

    public TraceTopicPublisher(TraceMessageProducer messageProducer, TopicPublisher delegate) {
        this.messageProducer = messageProducer;
        this.delegate = delegate;
    }

    public Topic getTopic() throws JMSException {
        return this.delegate.getTopic();
    }

    public void publish(Message message) throws JMSException {
        this.messageProducer.writeTraceContextToMessage(message);
        this.delegate.publish(message);
    }

    public void publish(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.writeTraceContextToMessage(message);
        this.delegate.publish(message, deliveryMode, priority, timeToLive);
    }

    public void publish(Topic topic, Message message) throws JMSException {
        this.messageProducer.writeTraceContextToMessage(message);
        this.delegate.publish(topic, message);
    }

    public void publish(Topic topic, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.writeTraceContextToMessage(message);
        this.delegate.publish(topic, message, deliveryMode, priority, timeToLive);
    }

    public void send(Message message) throws JMSException {
        this.messageProducer.send(message);
    }

    public void send(Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.send(message, deliveryMode, priority, timeToLive);
    }

    public void send(Destination destination, Message message) throws JMSException {
        this.messageProducer.send(destination, message);
    }

    public void send(Destination destination, Message message, int deliveryMode, int priority, long timeToLive) throws JMSException {
        this.messageProducer.send(destination, message, deliveryMode, priority, timeToLive);
    }

    public boolean getDisableMessageID() throws JMSException {
        return this.messageProducer.getDisableMessageID();
    }

    public void setDisableMessageID(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageID(value);
    }

    public boolean getDisableMessageTimestamp() throws JMSException {
        return this.messageProducer.getDisableMessageTimestamp();
    }

    public void setDisableMessageTimestamp(boolean value) throws JMSException {
        this.messageProducer.setDisableMessageTimestamp(value);
    }

    public int getDeliveryMode() throws JMSException {
        return this.messageProducer.getDeliveryMode();
    }

    public void setDeliveryMode(int deliveryMode) throws JMSException {
        this.messageProducer.setDeliveryMode(deliveryMode);
    }

    public int getPriority() throws JMSException {
        return this.messageProducer.getPriority();
    }

    public void setPriority(int defaultPriority) throws JMSException {
        this.messageProducer.setPriority(defaultPriority);
    }

    public long getTimeToLive() throws JMSException {
        return this.messageProducer.getTimeToLive();
    }

    public void setTimeToLive(long timeToLive) throws JMSException {
        this.messageProducer.setTimeToLive(timeToLive);
    }

    public Destination getDestination() throws JMSException {
        return this.messageProducer.getDestination();
    }

    public void close() throws JMSException {
        this.messageProducer.close();
    }
}

