/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.web;

import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public final class TraceInterceptor
implements HandlerInterceptor {
    private final Backend backend;
    private final HttpHeaderTransport httpHeaderSerialization;
    private String outgoingHeaderName = "TPIC";
    private String incomingHeaderName = "TPIC";
    private String profileName;

    public TraceInterceptor() {
        this(Builder.getBackend());
    }

    public TraceInterceptor(Backend backend) {
        this.backend = backend;
        this.httpHeaderSerialization = new HttpHeaderTransport();
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object o) {
        Enumeration headers;
        TraceFilterConfiguration configuration = this.backend.getConfiguration(this.profileName);
        if (configuration.shouldProcessContext(TraceFilterConfiguration.Channel.IncomingRequest) && (headers = request.getHeaders(this.incomingHeaderName)) != null && headers.hasMoreElements()) {
            Map<String, String> parsedContext = this.httpHeaderSerialization.parse(Collections.list(headers));
            this.backend.putAll(configuration.filterDeniedParams(parsedContext, TraceFilterConfiguration.Channel.IncomingResponse));
        }
        Builder.generateInvocationIdIfNecessary(this.backend);
        HttpSession session = request.getSession(false);
        if (session != null) {
            Builder.generateSessionIdIfNecessary(this.backend, session.getId());
        }
        this.writeHeaderIfUncommitted(response);
        return true;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object o, ModelAndView modelAndView) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object o, Exception e) {
        try {
            this.writeHeaderIfUncommitted(response);
        }
        finally {
            this.backend.clear();
        }
    }

    private void writeHeaderIfUncommitted(HttpServletResponse response) {
        TraceFilterConfiguration configuration;
        if (!response.isCommitted() && !this.backend.isEmpty() && (configuration = this.backend.getConfiguration(this.profileName)).shouldProcessContext(TraceFilterConfiguration.Channel.OutgoingResponse)) {
            Map<String, String> filteredContext = configuration.filterDeniedParams(this.backend.copyToMap(), TraceFilterConfiguration.Channel.OutgoingResponse);
            response.setHeader(this.outgoingHeaderName, this.httpHeaderSerialization.render(filteredContext));
        }
    }

    public void setOutgoingHeaderName(String outgoingHeaderName) {
        this.outgoingHeaderName = outgoingHeaderName;
    }

    public void setIncomingHeaderName(String incomingHeaderName) {
        this.incomingHeaderName = incomingHeaderName;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }
}

