/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.spring.amqp;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Envelope;
import java.util.HashMap;
import java.util.Map;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.support.DefaultMessagePropertiesConverter;

public class TraceMessagePropertiesConverter
extends DefaultMessagePropertiesConverter {
    private final Backend backend;
    private final String profile;

    public TraceMessagePropertiesConverter() {
        this(Builder.getBackend(), "default");
    }

    public TraceMessagePropertiesConverter(String profile) {
        this(Builder.getBackend(), profile);
    }

    TraceMessagePropertiesConverter(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
    }

    public MessageProperties toMessageProperties(AMQP.BasicProperties source, Envelope envelope, String charset) {
        Map<String, String> TraceContextMap;
        MessageProperties messageProperties = super.toMessageProperties(source, envelope, charset);
        TraceFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (filterConfiguration.shouldProcessContext(TraceFilterConfiguration.Channel.AsyncProcess) && (TraceContextMap = this.transformToTraceContextMap((Map)messageProperties.getHeaders().get("TPIC"))) != null && !TraceContextMap.isEmpty()) {
            this.backend.putAll(filterConfiguration.filterDeniedParams(TraceContextMap, TraceFilterConfiguration.Channel.AsyncProcess));
        }
        Builder.generateInvocationIdIfNecessary(this.backend);
        return messageProperties;
    }

    private Map<String, String> transformToTraceContextMap(Map<String, ?> tpicMessageHeader) {
        HashMap<String, String> TraceContext = new HashMap<String, String>();
        if (tpicMessageHeader != null) {
            for (Map.Entry<String, ?> stringObjectEntry : tpicMessageHeader.entrySet()) {
                TraceContext.put(stringObjectEntry.getKey(), String.valueOf(stringObjectEntry.getValue()));
            }
        }
        return TraceContext;
    }

    public AMQP.BasicProperties fromMessageProperties(MessageProperties source, String charset) {
        TraceFilterConfiguration filterConfiguration = this.backend.getConfiguration(this.profile);
        if (!this.backend.isEmpty() && filterConfiguration.shouldProcessContext(TraceFilterConfiguration.Channel.AsyncDispatch)) {
            Map<String, String> filteredParams = filterConfiguration.filterDeniedParams(this.backend.copyToMap(), TraceFilterConfiguration.Channel.AsyncDispatch);
            source.getHeaders().put("TPIC", filteredParams);
        }
        return super.fromMessageProperties(source, charset);
    }
}

