/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.jms;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Map;
import javax.interceptor.AroundInvoke;
import javax.interceptor.InvocationContext;
import javax.jms.JMSException;
import javax.jms.Message;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.transport.HttpHeaderTransport;

public final class TraceMessageListener {
    private final Backend backend;
    private final HttpHeaderTransport httpHeaderSerialization;

    TraceMessageListener(Backend backend) {
        this.backend = backend;
        this.httpHeaderSerialization = new HttpHeaderTransport();
    }

    public TraceMessageListener() {
        this(Builder.getBackend());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object intercept(InvocationContext ctx) throws Exception {
        boolean isMdbInvocation = this.isMessageListenerOnMessageMethod(ctx.getMethod());
        try {
            if (isMdbInvocation) {
                this.beforeProcessing(this.extractMessageParameter(ctx.getParameters()));
            }
            Object object = ctx.proceed();
            return object;
        }
        finally {
            if (isMdbInvocation) {
                this.cleanUp();
            }
        }
    }

    public void beforeProcessing(Message message) throws JMSException {
        String encodedTraceContext;
        if (this.backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.AsyncProcess) && (encodedTraceContext = message.getStringProperty("TPIC")) != null) {
            Map<String, String> contextFromMessage = this.httpHeaderSerialization.parse(Collections.singletonList(encodedTraceContext));
            this.backend.putAll(this.backend.getConfiguration().filterDeniedParams(contextFromMessage, TraceFilterConfiguration.Channel.AsyncProcess));
        }
        Builder.generateInvocationIdIfNecessary(this.backend);
    }

    void cleanUp() {
        if (this.backend.getConfiguration().shouldProcessContext(TraceFilterConfiguration.Channel.AsyncProcess)) {
            this.backend.clear();
        }
    }

    Message extractMessageParameter(Object[] parameters) {
        return (Message)parameters[0];
    }

    boolean isMessageListenerOnMessageMethod(Method method) {
        return "onMessage".equals(method.getName()) && method.getParameterTypes().length == 1 && method.getParameterTypes()[0] == Message.class;
    }
}

