/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.backend;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.aoju.bus.tracer.backend.AbstractBackend;
import org.slf4j.MDC;

class Slf4JAbstractBackend
extends AbstractBackend {
    protected final ThreadLocal<Set<String>> TraceKeys;

    Slf4JAbstractBackend(ThreadLocal<Set<String>> TraceKeys) {
        this.TraceKeys = TraceKeys;
    }

    @Override
    public boolean containsKey(String key) {
        return key != null && this.TraceKeys.get().contains(key) && MDC.get((String)key) != null;
    }

    @Override
    public int size() {
        return this.TraceKeys.get().size();
    }

    @Override
    public boolean isEmpty() {
        return this.TraceKeys.get().isEmpty();
    }

    @Override
    public String get(String key) {
        if (key != null && this.TraceKeys.get().contains(key)) {
            return MDC.get((String)key);
        }
        return null;
    }

    @Override
    public void put(String key, String value) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("null keys are not allowed.");
        }
        if (value == null) {
            throw new IllegalArgumentException("null values are not allowed.");
        }
        Set<String> registeredKeys = this.TraceKeys.get();
        if (!registeredKeys.contains(key)) {
            registeredKeys.add(key);
        }
        MDC.put((String)key, (String)value);
    }

    @Override
    public void remove(String key) throws IllegalArgumentException {
        if (key == null) {
            throw new IllegalArgumentException("null keys are not allowed.");
        }
        if (this.TraceKeys.get().remove(key)) {
            MDC.remove((String)key);
        }
    }

    @Override
    public void clear() {
        for (String key : this.TraceKeys.get()) {
            MDC.remove((String)key);
        }
        this.TraceKeys.remove();
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> entries) {
        for (Map.Entry<? extends String, ? extends String> entry : entries.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Map<String, String> copyToMap() {
        HashMap<String, String> TraceMap = new HashMap<String, String>();
        Set<String> keys = this.TraceKeys.get();
        for (String TraceKey : keys) {
            String value = MDC.get((String)TraceKey);
            if (value == null) continue;
            TraceMap.put(TraceKey, value);
        }
        return TraceMap;
    }
}

