/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.aoju.bus.core.utils.StringUtils;
import org.aoju.bus.logger.Logger;
import org.aoju.bus.tracer.config.PropertyChain;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.aoju.bus.tracer.config.TracePropertiesFileLoader;

public final class PropertiesBasedTraceFilterConfiguration
implements TraceFilterConfiguration {
    static final String Trace_CONFIG_PREFIX = "Builder.";
    static final String PROFILED_PREFIX = "Builder.profile.";
    static final String Trace_DEFAULT_PROFILE_PREFIX = "Builder.default.";
    static final String GENERATE_INVOCATION_ID = "invocationIdLength";
    static final String GENERATE_SESSION_ID = "sessionIdLength";
    private final PropertyChain propertyChain;
    private final String profileName;
    private final Map<String, List<Pattern>> patternCache = new ConcurrentHashMap<String, List<Pattern>>();

    public PropertiesBasedTraceFilterConfiguration(PropertyChain propertyChain) {
        this(propertyChain, null);
    }

    public PropertiesBasedTraceFilterConfiguration(PropertyChain propertyChain, String profileName) {
        this.propertyChain = propertyChain;
        this.profileName = profileName;
    }

    public static PropertyChain loadPropertyChain() {
        try {
            Properties TraceDefaultFileProperties = new TracePropertiesFileLoader().loadTraceProperties("META-INF/tracer.default.properties");
            Properties TraceFileProperties = new TracePropertiesFileLoader().loadTraceProperties("META-INF/tracer.properties");
            return PropertyChain.build(System.getProperties(), TraceFileProperties, TraceDefaultFileProperties);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("Could not load TraceProperties: " + ioe.getMessage(), ioe);
        }
    }

    private String getProfiledOrDefaultProperty(String propertyName) {
        String profiledProperty;
        if (this.profileName != null && !"default".equals(this.profileName) && (profiledProperty = this.propertyChain.getProperty(PROFILED_PREFIX + this.profileName + '.' + propertyName)) != null) {
            return profiledProperty;
        }
        return this.propertyChain.getProperty(Trace_DEFAULT_PROFILE_PREFIX + propertyName);
    }

    @Override
    public boolean shouldProcessParam(String paramName, TraceFilterConfiguration.Channel channel) {
        String messageTypePropertyValue = this.getProfiledOrDefaultProperty(channel.name());
        List<Pattern> patterns = this.retrievePatternsForPropertyValue(messageTypePropertyValue);
        return this.anyPatternMatchesParamName(patterns, paramName);
    }

    @Override
    public boolean shouldProcessContext(TraceFilterConfiguration.Channel channel) {
        String messageTypePropertyValue = this.getProfiledOrDefaultProperty(channel.name());
        return !StringUtils.isEmpty((Object)messageTypePropertyValue);
    }

    @Override
    public boolean shouldGenerateInvocationId() {
        return this.generatedInvocationIdLength() > 0;
    }

    @Override
    public int generatedInvocationIdLength() {
        return this.parseIntOrZero(this.getProfiledOrDefaultProperty(GENERATE_INVOCATION_ID));
    }

    @Override
    public boolean shouldGenerateSessionId() {
        return this.generatedSessionIdLength() > 0;
    }

    @Override
    public int generatedSessionIdLength() {
        return this.parseIntOrZero(this.getProfiledOrDefaultProperty(GENERATE_SESSION_ID));
    }

    @Override
    public Map<String, String> filterDeniedParams(Map<String, String> unfiltered, TraceFilterConfiguration.Channel channel) {
        HashMap<String, String> filtered = new HashMap<String, String>(unfiltered.size());
        for (Map.Entry<String, String> entry : unfiltered.entrySet()) {
            if (!this.shouldProcessParam(entry.getKey(), channel)) continue;
            filtered.put(entry.getKey(), entry.getValue());
        }
        return filtered;
    }

    private int parseIntOrZero(String intString) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException nfe) {
            return 0;
        }
    }

    private boolean anyPatternMatchesParamName(Iterable<Pattern> patterns, String paramName) {
        for (Pattern pattern : patterns) {
            if (!this.patternMatchesParamName(pattern, paramName)) continue;
            return true;
        }
        return false;
    }

    private boolean patternMatchesParamName(Pattern pattern, String paramName) {
        return ".*".equals(pattern.pattern()) || pattern.matcher(paramName).matches();
    }

    private List<Pattern> retrievePatternsForPropertyValue(String propertyValue) {
        if (propertyValue == null) {
            return Collections.emptyList();
        }
        List<Pattern> patterns = this.patternCache.get(propertyValue);
        if (patterns != null) {
            return patterns;
        }
        List<Pattern> unmodPatterns = Collections.unmodifiableList(this.extractPatterns(propertyValue));
        this.patternCache.put(propertyValue, unmodPatterns);
        return unmodPatterns;
    }

    List<Pattern> extractPatterns(String propertyValue) {
        if (propertyValue == null) {
            return Collections.emptyList();
        }
        ArrayList<Pattern> trimmedPatterns = new ArrayList<Pattern>();
        StringTokenizer tokenizer = new StringTokenizer(propertyValue, ",");
        while (tokenizer.hasMoreTokens()) {
            String trimmedString = tokenizer.nextToken().trim();
            if (trimmedString.isEmpty()) continue;
            try {
                trimmedPatterns.add(Pattern.compile(trimmedString));
            }
            catch (PatternSyntaxException e) {
                Logger.error((String)("Can not compile pattern '" + trimmedString + "'. Message: " + e.getMessage() + " -- Ignore pattern"), (Object[])new Object[0]);
                Logger.debug((String)("Detailed Exception cause: " + e.getMessage()), (Object[])new Object[]{e});
            }
        }
        return trimmedPatterns;
    }
}

