/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.binding.quartz;

import java.util.Map;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.Builder;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.listeners.JobListenerSupport;

public class TraceJobListener
extends JobListenerSupport {
    private final Backend backend;
    private final String profile;

    public TraceJobListener() {
        this(Builder.getBackend(), "default");
    }

    public TraceJobListener(String profile) {
        this(Builder.getBackend(), profile);
    }

    TraceJobListener(Backend backend, String profile) {
        this.backend = backend;
        this.profile = profile;
    }

    public String getName() {
        return "Builder job listener";
    }

    public void jobToBeExecuted(JobExecutionContext context) {
        Map TraceContext;
        TraceFilterConfiguration configuration = this.backend.getConfiguration(this.profile);
        if (configuration.shouldProcessContext(TraceFilterConfiguration.Channel.AsyncProcess) && (TraceContext = (Map)context.getMergedJobDataMap().get((Object)"TPIC")) != null && !TraceContext.isEmpty()) {
            Map<String, String> filteredContext = configuration.filterDeniedParams(TraceContext, TraceFilterConfiguration.Channel.AsyncProcess);
            this.backend.putAll(filteredContext);
        }
        Builder.generateInvocationIdIfNecessary(this.backend);
    }

    public void jobExecutionVetoed(JobExecutionContext context) {
        this.backend.clear();
    }

    public void jobWasExecuted(JobExecutionContext context, JobExecutionException jobException) {
        this.backend.clear();
    }
}

