/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.backend;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.aoju.bus.tracer.Backend;
import org.aoju.bus.tracer.config.PropertiesBasedTraceFilterConfiguration;
import org.aoju.bus.tracer.config.PropertyChain;
import org.aoju.bus.tracer.config.TraceFilterConfiguration;

public abstract class AbstractBackend
implements Backend {
    private PropertyChain _lazyPropertyChain;
    private Map<String, TraceFilterConfiguration> configurationCache = new ConcurrentHashMap<String, TraceFilterConfiguration>();

    @Override
    public final TraceFilterConfiguration getConfiguration() {
        return this.getConfiguration(null);
    }

    @Override
    public final TraceFilterConfiguration getConfiguration(String profileName) {
        String lookupProfile = profileName == null ? "default" : profileName;
        TraceFilterConfiguration filterConfiguration = this.configurationCache.get(lookupProfile);
        if (filterConfiguration == null) {
            filterConfiguration = new PropertiesBasedTraceFilterConfiguration(this.getPropertyChain(), lookupProfile);
            this.configurationCache.put(lookupProfile, filterConfiguration);
        }
        return filterConfiguration;
    }

    @Override
    public String getInvocationId() {
        return this.get("TPIC.invocationId");
    }

    @Override
    public String getSessionId() {
        return this.get("TPIC.sessionId");
    }

    private PropertyChain getPropertyChain() {
        if (this._lazyPropertyChain == null) {
            this._lazyPropertyChain = PropertiesBasedTraceFilterConfiguration.loadPropertyChain();
        }
        return this._lazyPropertyChain;
    }
}

