/*
 * Decompiled with CFR 0.152.
 */
package org.aoju.bus.tracer.transport.jaxb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlValue;

@XmlRootElement(name="TPIC")
@XmlAccessorType(value=XmlAccessType.NONE)
public final class TpicMap {
    @XmlElement(name="entry")
    public final List<Entry> entries;

    public TpicMap(List<Entry> entries) {
        this.entries = entries;
    }

    private TpicMap() {
        this.entries = null;
    }

    public static TpicMap wrap(Map<String, String> map) {
        ArrayList<Entry> values = new ArrayList<Entry>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            values.add(new Entry(entry.getKey(), entry.getValue()));
        }
        return new TpicMap(values);
    }

    public Map<String, String> unwrapValues() {
        if (this.entries == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (Entry value : this.entries) {
            map.put(value.key, value.value);
        }
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TpicMap tpicMap = (TpicMap)o;
        return !(this.entries != null ? !this.entries.equals(tpicMap.entries) : tpicMap.entries != null);
    }

    public int hashCode() {
        return this.entries != null ? this.entries.hashCode() : 0;
    }

    public static final class Entry {
        @XmlAttribute(name="key", required=true)
        public final String key;
        @XmlValue
        public final String value;

        public Entry(String key, String value) {
            this.key = key;
            this.value = value;
        }

        protected Entry() {
            this.key = null;
            this.value = null;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Entry entry = (Entry)o;
            if (this.key != null ? !this.key.equals(entry.key) : entry.key != null) {
                return false;
            }
            return !(this.value != null ? !this.value.equals(entry.value) : entry.value != null);
        }

        public int hashCode() {
            int result = this.key != null ? this.key.hashCode() : 0;
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            return result;
        }
    }
}

